/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.computer;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.computer.theme.ComputerTheme;
import com.mraof.minestuck.computer.theme.ComputerThemes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public abstract class ThemedScreen
extends Screen {
    public static final ResourceLocation GUI_MAIN = Minestuck.id("textures/gui/sburb.png");
    public static final ResourceLocation GUI_BSOD = Minestuck.id("textures/gui/bsod_message.png");
    public static final int GUI_WIDTH = 176;
    public static final int GUI_HEIGHT = 166;
    public static final int COMPUTER_SCREEN_WIDTH = 158;
    public static final int COMPUTER_SCREEN_HEIGHT = 120;
    public static final int SCREEN_OFFSET_X = 9;
    public static final int SCREEN_OFFSET_Y = 38;
    public final ComputerBlockEntity computer;
    public ComputerTheme selectedTheme;
    public PowerButton powerButton;
    public int xOffset;
    public int yOffset;

    public ThemedScreen(ComputerBlockEntity computer, MutableComponent title) {
        super((Component)title);
        this.computer = computer;
        this.selectedTheme = ComputerThemes.instance().lookup(computer.getTheme());
    }

    public void init() {
        this.setOffsets();
        this.powerButton = this.addRenderableWidget(new PowerButton(this));
        if (!this.selectedTheme.id().equals((Object)this.computer.getTheme())) {
            this.selectedTheme = ComputerThemes.instance().lookup(this.computer.getTheme());
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.setOffsets();
        guiGraphics.blit(GUI_MAIN, this.xOffset + 9, this.yOffset + 38, 176, 0, 3, 3);
        guiGraphics.blit(GUI_MAIN, this.xOffset + 164, this.yOffset + 38, 179, 0, 3, 3);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        boolean bsod = this.computer.isBrokenOrOff();
        guiGraphics.blit(GUI_MAIN, this.xOffset, this.yOffset, 0, 0, 176, 166);
        if (bsod) {
            guiGraphics.blit(GUI_BSOD, this.xOffset + 9, this.yOffset + 38, 0, 0, 158, 120);
        } else {
            guiGraphics.blit(this.selectedTheme.data().texturePath(), this.xOffset + 9, this.yOffset + 38, 0, 0, 158, 120);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void setOffsets() {
        this.xOffset = this.width / 2 - 88;
        this.yOffset = this.height / 2 - 83;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            MSScreenFactories.displayComputerScreen(this.computer);
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T button) {
        return (T)super.addRenderableWidget(button);
    }

    public class PowerButton
    extends Button {
        public PowerButton(ThemedScreen this$0) {
            super(PowerButton.builder((Component)Component.empty(), b -> this$0.minecraft.setScreen(null)).pos((this$0.width - 176) / 2 + 143, (this$0.height - 166) / 2 + 3).size(29, 29));
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float pt) {
        }
    }
}

