/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.playerStats;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.client.gui.playerStats.PlayerStatsContainerScreen;
import com.mraof.minestuck.inventory.AtheneumMenu;
import com.mraof.minestuck.network.editmode.AtheneumPackets;
import java.time.LocalDate;
import java.time.Month;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class AtheneumScreen
extends PlayerStatsContainerScreen<AtheneumMenu> {
    public static final String TITLE = "minestuck.atheneum";
    private static final ResourceLocation GUI_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/gui_inv_atheneum.png");
    private static final int UP_ARROW_Y = 14;
    private static final int DOWN_ARROW_Y = 48;
    private static final int ARROW_X = 151;
    public boolean more;
    public boolean less;

    public AtheneumScreen(int windowId, Inventory playerInventory) {
        super(new AtheneumMenu(windowId, playerInventory), playerInventory, (Component)Component.translatable((String)TITLE));
        this.guiWidth = 176;
        this.guiHeight = 98;
        this.titleLabelX = 6;
        this.titleLabelY = 4;
    }

    protected void renderBg(GuiGraphics guiGraphics, float par1, int xcor, int ycor) {
        this.drawTabs(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(GUI_BACKGROUND, this.xOffset, this.yOffset, 0, 0, this.guiWidth, this.guiHeight);
        LocalDate localdate = LocalDate.now();
        int d = localdate.getDayOfMonth();
        Month m = localdate.getMonth();
        boolean hardmode = (Boolean)MinestuckConfig.SERVER.hardMode.get();
        boolean memeNumberDate = !hardmode && (m == Month.APRIL && d == 13 || m == Month.JUNE && d == 12 || m == Month.OCTOBER && d == 25 || m == Month.NOVEMBER && d == 11 || m == Month.NOVEMBER && d == 27);
        guiGraphics.blit(GUI_BACKGROUND, this.xOffset + 151, this.yOffset + 14, this.guiWidth + (memeNumberDate ? 36 : 0), (this.less ? 0 : 18) + (hardmode ? 36 : 0), 18, 18);
        guiGraphics.blit(GUI_BACKGROUND, this.xOffset + 151, this.yOffset + 48, this.guiWidth + 18 + (memeNumberDate ? 36 : 0), (this.more ? 0 : 18) + (hardmode ? 36 : 0), 18, 18);
        this.drawActiveTabAndIcons(guiGraphics);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    @Override
    public boolean mouseClicked(double xcor, double ycor, int mouseButton) {
        if (xcor >= (double)(this.xOffset + 151) && xcor < (double)(this.xOffset + 151 + 18)) {
            AtheneumPackets.Scroll packet = null;
            if (this.less && ycor >= (double)(this.yOffset + 14) && ycor < (double)(this.yOffset + 14 + 18)) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                packet = new AtheneumPackets.Scroll(true);
            } else if (this.more && ycor >= (double)(this.yOffset + 48) && ycor < (double)(this.yOffset + 48 + 18)) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                packet = new AtheneumPackets.Scroll(false);
            }
            if (packet != null) {
                PacketDistributor.sendToServer(packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return super.mouseClicked(xcor, ycor, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (mouseX >= (double)this.xOffset && mouseX < (double)(this.xOffset + this.guiWidth) && mouseY >= (double)this.yOffset && mouseY < (double)(this.yOffset + this.guiHeight)) {
            AtheneumPackets.Scroll packet = null;
            if (this.less && scrollY > 0.0) {
                packet = new AtheneumPackets.Scroll(true);
            } else if (this.more && scrollY < 0.0) {
                packet = new AtheneumPackets.Scroll(false);
            }
            if (packet != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }
}

