/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.playerStats;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.client.gui.playerStats.PlayerStatsContainerScreen;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckMenu;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.inventory.captchalogue.ModusTypes;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.network.CaptchaDeckPackets;
import com.mraof.minestuck.player.ClientPlayerData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class CaptchaDeckScreen
extends PlayerStatsContainerScreen<CaptchaDeckMenu> {
    public static final String TITLE = "minestuck.captcha_deck";
    public static final String SYLLADEX = "minestuck.sylladex";
    public static final String USE_ITEM = "minestuck.captcha_deck.use_item";
    private static final ResourceLocation guiCaptchaDeck = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/captcha_deck.png");
    private Button modusButton;
    private Button sylladexMap;

    public CaptchaDeckScreen(int windowId, Inventory playerInventory) {
        super(new CaptchaDeckMenu(windowId, playerInventory), playerInventory, (Component)Component.translatable((String)TITLE));
        this.guiWidth = 178;
        this.guiHeight = 145;
    }

    @Override
    public void init() {
        super.init();
        this.modusButton = (Button)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.xOffset + 102, this.yOffset + 31, 50, 18, (Component)Component.translatable((String)USE_ITEM), button -> this.use()));
        this.sylladexMap = (Button)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.xOffset + 6, this.yOffset + 31, 60, 18, (Component)Component.translatable((String)SYLLADEX), button -> this.sylladex()));
        this.sylladexMap.active = ClientPlayerData.getModus() != null;
        this.modusButton.active = !((CaptchaDeckMenu)this.menu).getMenuItem().isEmpty();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.sylladexMap.active = ClientPlayerData.getModus() != null;
        this.modusButton.active = !((CaptchaDeckMenu)this.menu).getMenuItem().isEmpty();
        this.drawTabs(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(guiCaptchaDeck, this.xOffset, this.yOffset, 0, 0, this.guiWidth, this.guiHeight);
        this.drawActiveTabAndIcons(guiGraphics);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String message = this.getTitle().getString();
        guiGraphics.drawString(this.font, message, (float)this.width / 2.0f - (float)this.font.width(message) / 2.0f - (float)this.leftPos, (float)(this.yOffset + 12 - this.topPos), 0x404040, false);
    }

    private void use() {
        ItemStack stack = ((CaptchaDeckMenu)this.menu).getMenuItem();
        if (!stack.isEmpty()) {
            if (!(stack.getItem() instanceof CaptchaCardItem)) {
                ModusType<?> type = ModusTypes.getTypeFromItem(stack.getItem());
                Object newModus = type.createClientSide();
                Modus modus = ClientPlayerData.getModus();
                if (newModus != null && modus != null && newModus.getClass() != modus.getClass() && !((Modus)newModus).canSwitchFrom(modus)) {
                    this.minecraft.screen = new ConfirmScreen(this::onConfirm, (Component)Component.translatable((String)"minestuck.empty_sylladex.1"), (Component)Component.translatable((String)"minestuck.empty_sylladex.2")){

                        public void removed() {
                            this.minecraft.screen = CaptchaDeckScreen.this;
                            this.minecraft.player.closeContainer();
                        }
                    };
                    this.minecraft.screen.init(this.minecraft, this.width, this.height);
                    return;
                }
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new CaptchaDeckPackets.TriggerModusButton(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void sylladex() {
        if (ClientPlayerData.getModus() != null) {
            this.minecraft.player.connection.send((Packet)new ServerboundContainerClosePacket(this.minecraft.player.containerMenu.containerId));
            MSScreenFactories.displaySylladexScreen(ClientPlayerData.getModus());
            this.minecraft.player.containerMenu = this.minecraft.player.inventoryMenu;
        }
    }

    private void onConfirm(boolean result) {
        if (result && !((CaptchaDeckMenu)this.menu).getMenuItem().isEmpty()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CaptchaDeckPackets.TriggerModusButton(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.minecraft.screen = this;
    }
}

