/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.playerStats;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.client.util.MSKeyHandler;
import com.mraof.minestuck.network.DataCheckerPackets;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.EnumClass;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataCheckerScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation icons = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/icons.png");
    private static final ResourceLocation guiBackground = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/data_check.png");
    private static final int GUI_WIDTH = 210;
    private static final int GUI_HEIGHT = 140;
    private static final int LIST_Y = 25;
    public static IDataComponent activeComponent = null;
    private IDataComponent guiComponent;
    private Button[] contentButtons = new Button[5];
    private Button returnButton;
    private Button refreshButton;
    private int index;
    private float displayIndex;
    private boolean isScrolling;

    public DataCheckerScreen() {
        super((Component)Component.literal((String)"Data Checker"));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        int xOffset = (this.width - 210) / 2;
        int yOffset = (this.height - 140) / 2;
        for (int i = 0; i < 5; ++i) {
            int id = i;
            this.contentButtons[id] = (Button)this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 5, yOffset + 25 + i * 22, 180, 20, (Component)Component.empty(), button -> this.contentButton(id)));
        }
        this.returnButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.goBack()).pos(xOffset + 210 - 25, yOffset + 5).size(18, 18).build());
        this.refreshButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.refresh()).pos(xOffset + 210 - 45, yOffset + 5).size(18, 18).build());
        if (activeComponent == null) {
            PacketDistributor.sendToServer((CustomPacketPayload)DataCheckerPackets.Request.create(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.componentChanged();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int xOffset = (this.width - 210) / 2;
        int yOffset = (this.height - 140) / 2;
        guiGraphics.blit(guiBackground, xOffset, yOffset, 0, 0, 210, 140);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        boolean canScroll;
        int xOffset = (this.width - 210) / 2;
        int yOffset = (this.height - 140) / 2;
        boolean bl = canScroll = this.guiComponent != null && this.guiComponent.getComponentList().size() > 5;
        if (canScroll && this.isScrolling) {
            this.displayIndex = ((float)(mouseY - yOffset) - 28.5f) / 91.0f;
            this.displayIndex = Mth.clamp((float)this.displayIndex, (float)0.0f, (float)1.0f);
            int newIndex = (int)((double)((float)(this.guiComponent.getComponentList().size() - 5) * this.displayIndex) + 0.5);
            if (newIndex != this.index) {
                this.index = newIndex;
                this.updateGuiButtons();
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.returnButton.active) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        guiGraphics.blit(icons, xOffset + 210 - 24, yOffset + 6, 240, 0, 16, 16);
        if (this.refreshButton.active) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        guiGraphics.blit(icons, xOffset + 210 - 44, yOffset + 6, 224, 0, 16, 16);
        if (this.guiComponent != null) {
            List<IDataComponent> list = this.guiComponent.getComponentList();
            for (int i = 0; i < 5; ++i) {
                IDataComponent component;
                String string = this.guiComponent.getName();
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, string, xOffset + 9, yOffset + 15 - 9 / 2, 0, false);
                IDataComponent iDataComponent = component = i + this.index < list.size() ? list.get(i + this.index) : null;
                if (component == null || component.isButton()) continue;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blit(guiBackground, xOffset + 5, yOffset + 25 + i * 22, 0, 236, 180, 20);
                String string2 = component.getName();
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, string2, xOffset + 9, yOffset + 25 + 10 - 9 / 2 + i * 22, 0, false);
            }
        } else {
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, "Retrieving data from server...", xOffset + 9, yOffset + 15 - 9 / 2, 0, false);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textureIndex = canScroll ? 232 : 244;
        guiGraphics.blit(guiBackground, (this.width - 210) / 2 + 190, (this.height - 140) / 2 + 25 + 1 + (int)this.displayIndex * 91, textureIndex, 0, 12, 15);
    }

    public void tick() {
        if (this.guiComponent != activeComponent) {
            this.componentChanged();
        }
        if (!ClientPlayerData.hasDataCheckerAccess()) {
            this.minecraft.setScreen(null);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0 && this.guiComponent != null) {
            int size = this.guiComponent.getComponentList().size();
            if (size <= 5) {
                return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
            }
            int prevIndex = this.index--;
            if (!(scrollY > 0.0)) {
                ++this.index;
            }
            this.index = Mth.clamp((int)this.index, (int)0, (int)(size - 5));
            if (this.index != prevIndex) {
                this.displayIndex = (float)this.index / ((float)size - 5.0f);
                this.updateGuiButtons();
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int xOffset = (this.width - 210) / 2;
        int yOffset = (this.height - 140) / 2;
        if (mouseButton == 0 && mouseX >= (double)(xOffset + 190) && mouseX < (double)(xOffset + 202) && mouseY >= (double)(yOffset + 25 + 1) && mouseY < (double)(yOffset + 25 + 102)) {
            this.isScrolling = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    private void contentButton(int id) {
        IDataComponent component;
        int buttonIndex = this.index + id;
        if (buttonIndex < this.guiComponent.getComponentList().size() && this.guiComponent.getComponentList().get(buttonIndex) != null && (component = this.guiComponent.getComponentList().get(buttonIndex).onButtonPressed()) != null) {
            activeComponent = component;
            this.componentChanged();
        }
    }

    private void goBack() {
        if (this.guiComponent != null && this.guiComponent.getParentComponent() != null) {
            activeComponent = this.guiComponent.getParentComponent();
            this.componentChanged();
        }
    }

    private void refresh() {
        PacketDistributor.sendToServer((CustomPacketPayload)DataCheckerPackets.Request.create(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        activeComponent = null;
        this.componentChanged();
    }

    public void componentChanged() {
        this.index = 0;
        this.displayIndex = 0.0f;
        this.guiComponent = activeComponent;
        this.returnButton.active = this.guiComponent != null && this.guiComponent.getParentComponent() != null;
        this.refreshButton.active = this.guiComponent != null;
        this.updateGuiButtons();
    }

    public void updateGuiButtons() {
        if (this.guiComponent != null) {
            List<IDataComponent> components = this.guiComponent.getComponentList();
            for (int i = 0; i < 5; ++i) {
                IDataComponent component;
                Button button = this.contentButtons[i];
                IDataComponent iDataComponent = component = i + this.index < components.size() ? components.get(i + this.index) : null;
                if (component != null && component.isButton()) {
                    button.visible = true;
                    button.setMessage((Component)Component.literal((String)component.getName()));
                    continue;
                }
                button.visible = false;
            }
        } else {
            for (Button button : this.contentButtons) {
                button.visible = false;
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int i) {
        if (MSKeyHandler.statKey.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.minecraft.setScreen(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, i);
    }

    public static interface IDataComponent {
        public IDataComponent getParentComponent();

        public List<IDataComponent> getComponentList();

        public IDataComponent onButtonPressed();

        public boolean isButton();

        public String getName();
    }

    public static class GristCacheButton
    implements IDataComponent {
        String name;

        public GristCacheButton(String name) {
            this.name = name;
        }

        @Override
        public IDataComponent getParentComponent() {
            return null;
        }

        @Override
        public List<IDataComponent> getComponentList() {
            return null;
        }

        @Override
        public IDataComponent onButtonPressed() {
            ChatScreen chat = new ChatScreen("/grist @" + this.name + " get");
            Minecraft.getInstance().setScreen((Screen)chat);
            return null;
        }

        @Override
        public boolean isButton() {
            return true;
        }

        @Override
        public String getName() {
            return "View Grist Cache";
        }
    }

    public static class ConnectionComponent
    implements IDataComponent {
        List<IDataComponent> list = new ArrayList<IDataComponent>();
        SessionComponent parent;
        String client;
        String server;
        boolean isMain;
        String landDim = "";

        public ConnectionComponent(SessionComponent parent, CompoundTag connectionTag, CompoundTag dataTag) {
            this.parent = parent;
            this.client = connectionTag.getString("client");
            this.server = connectionTag.getString("server");
            this.isMain = connectionTag.getBoolean("isMain");
            if (this.isMain) {
                this.landDim = connectionTag.getString("clientDim");
            }
            this.list.add(new TextField("Client Player: %s", this.client));
            if (!this.server.isEmpty()) {
                this.list.add(new TextField("Server Player: %s", this.server));
            }
            this.list.add(new TextField("Is Primary Connection: %b", this.isMain));
            this.list.add(null);
            this.list.add(new TextField("Land dim: %s", !this.landDim.isEmpty() ? this.landDim : "Pre-entry"));
            if (!this.landDim.isEmpty() && connectionTag.contains("landTypes")) {
                LandTypePair.Named.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)connectionTag.get("landTypes")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(namedTypes -> this.list.add(new LocalizedTextField((Component)namedTypes.asComponent())));
            }
            if (connectionTag.contains("class")) {
                byte cl = connectionTag.getByte("class");
                byte as = connectionTag.getByte("aspect");
                Title title = new Title(EnumClass.values()[cl], EnumAspect.values()[as]);
                this.list.add(new TextField(title.asTextComponent().getString()));
            }
            if (connectionTag.contains("titleLandType")) {
                this.list.add(new TextField("Title land type: %s", connectionTag.getString("titleLandType")));
            }
            if (connectionTag.contains("terrainLandType")) {
                this.list.add(new TextField("Terrain land type: %s", connectionTag.getString("terrainLandType")));
            }
            this.list.add(new GristCacheButton(connectionTag.getString("clientId")));
        }

        @Override
        public IDataComponent getParentComponent() {
            return this.parent;
        }

        @Override
        public List<IDataComponent> getComponentList() {
            return this.list;
        }

        @Override
        public IDataComponent onButtonPressed() {
            return this;
        }

        @Override
        public boolean isButton() {
            return true;
        }

        @Override
        public String getName() {
            if (this.isMain) {
                return String.format("'%s' - %s", this.client, this.server.isEmpty() ? Character.valueOf('?') : "'" + this.server + "'");
            }
            return String.format("('%s' - '%s')", this.client, this.server);
        }
    }

    public static class SessionComponent
    implements IDataComponent {
        List<IDataComponent> list = new ArrayList<IDataComponent>();
        MainComponent parent;
        String name;
        int players;
        int playersEntered;

        public SessionComponent(MainComponent parent, CompoundTag sessionTag, CompoundTag dataTag) {
            this.parent = parent;
            HashSet<String> playerSet = new HashSet<String>();
            ListTag connectionList = sessionTag.getList("connections", 10);
            for (int i = 0; i < connectionList.size(); ++i) {
                ConnectionComponent connection = new ConnectionComponent(this, connectionList.getCompound(i), dataTag);
                this.list.add(connection);
                if (!connection.landDim.isEmpty()) {
                    ++this.playersEntered;
                }
                playerSet.add(connection.client);
                playerSet.add(connection.server);
            }
            playerSet.remove("");
            this.players = playerSet.size();
        }

        @Override
        public IDataComponent getParentComponent() {
            return this.parent;
        }

        @Override
        public List<IDataComponent> getComponentList() {
            return this.list;
        }

        @Override
        public IDataComponent onButtonPressed() {
            return this;
        }

        @Override
        public boolean isButton() {
            return true;
        }

        @Override
        public String getName() {
            return String.format("%s (%d/%d)", this.name, this.playersEntered, this.players);
        }
    }

    public static class MainComponent
    implements IDataComponent {
        List<IDataComponent> list = new ArrayList<IDataComponent>();

        public MainComponent(CompoundTag data) {
            if (data == null || data.isEmpty()) {
                return;
            }
            ListTag sessionList = data.getList("sessions", 10);
            int nameIndex = 1;
            for (int i = 0; i < sessionList.size(); ++i) {
                CompoundTag sessionTag = sessionList.getCompound(i);
                SessionComponent session = new SessionComponent(this, sessionTag, data);
                session.name = "Session " + nameIndex++;
                this.list.add(session);
            }
        }

        @Override
        public IDataComponent getParentComponent() {
            return null;
        }

        @Override
        public List<IDataComponent> getComponentList() {
            return this.list;
        }

        @Override
        public IDataComponent onButtonPressed() {
            return this;
        }

        @Override
        public boolean isButton() {
            return true;
        }

        @Override
        public String getName() {
            return "Data Checker";
        }
    }

    public record LocalizedTextField(Component component) implements IDataComponent
    {
        public LocalizedTextField(String message, Object ... params) {
            this((Component)Component.translatable((String)message, (Object[])params));
        }

        @Override
        public IDataComponent getParentComponent() {
            return null;
        }

        @Override
        public List<IDataComponent> getComponentList() {
            return null;
        }

        @Override
        public IDataComponent onButtonPressed() {
            return null;
        }

        @Override
        public boolean isButton() {
            return false;
        }

        @Override
        public String getName() {
            return this.component.getString();
        }
    }

    public static class TextField
    implements IDataComponent {
        String message;

        public TextField(String message, Object ... args) {
            this(String.format(message, args));
        }

        public TextField(String message) {
            this.message = message;
        }

        @Override
        public IDataComponent getParentComponent() {
            return null;
        }

        @Override
        public List<IDataComponent> getComponentList() {
            return null;
        }

        @Override
        public IDataComponent onButtonPressed() {
            return null;
        }

        @Override
        public boolean isButton() {
            return false;
        }

        @Override
        public String getName() {
            return this.message;
        }
    }
}

