/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.playerStats;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.client.ClientRungData;
import com.mraof.minestuck.client.gui.playerStats.PlayerStatsScreen;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.player.Rung;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;

public class EcheladderScreen
extends PlayerStatsScreen {
    public static final String TITLE = "minestuck.echeladder";
    public static final String ATTACK = "minestuck.echeladder.attack";
    public static final String HEALTH = "minestuck.echeladder.health";
    public static final String CACHE = "minestuck.echeladder.cache";
    public static final String DAMAGE_UNDERLING = "minestuck.echeladder.damage_underling";
    public static final String DAMAGE_UNDERLING_INCREASE = "minestuck.echeladder.damage_underling.increase";
    public static final String PROTECTION_UNDERLING = "minestuck.echeladder.protection_underling";
    public static final String PROTECTION_UNDERLING_INCREASE = "minestuck.echeladder.protection_underling.increase";
    private static final ResourceLocation guiEcheladder = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/echeladder.png");
    private static final int RUNG_Y = 14;
    private static final int VISIBLE_RUNG_COUNT = 12;
    private static final int GREY = 0x404040;
    private static final int BLUE = 38143;
    private static final int TIME_BEFORE_ANIMATION = 10;
    private static final int TIME_BEFORE_NEXT = 16;
    private static final int TIME_FOR_RUNG = 4;
    private static final int TIME_FOR_SHOW_ONLY = 65;
    private static final int TIME_TILL_NEXT = 20;
    private int scroll = 0;
    private final int maxScroll;
    private final List<RungBar> rungBars = new ArrayList<RungBar>();
    public static int lastRung = -1;
    public static int animatedRung;
    private boolean showLastRung = true;
    private int currentRung;
    private int fromRung;
    private int animationCycle;
    private int animatedRungs;

    public EcheladderScreen() {
        super((Component)Component.translatable((String)TITLE));
        this.guiWidth = 250;
        this.guiHeight = 202;
        this.maxScroll = ClientRungData.getFinalRungIndex() - 10;
    }

    @Override
    public void init() {
        super.init();
        animatedRung = Math.max(animatedRung, lastRung);
        this.fromRung = lastRung;
        lastRung = ClientPlayerData.getRung();
        this.rungBars.clear();
        for (int i = 0; i <= ClientRungData.getFinalRungIndex(); ++i) {
            MutableComponent name = I18n.exists((String)("echeladder.rung." + i)) ? Component.translatable((String)("echeladder.rung." + i)) : Component.literal((String)("Rung " + (i + 1)));
            Optional<String> tooltip = ClientRungData.getData(i).description();
            RungBar rungBar = new RungBar(this.xOffset + 90, this.yOffset + 175 - i * 14, 146, 14, (Component)name, tooltip, i);
            this.rungBars.add(rungBar);
            this.addRenderableWidget((GuiEventListener)rungBar);
            rungBar.visible = i <= 12;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.updateAnimation();
        int speedFactor = ((MinestuckConfig.AnimationSpeed)((Object)MinestuckConfig.CLIENT.echeladderAnimation.get())).getSpeed();
        this.calculateRungAnimationStep(speedFactor);
        this.rungBars.forEach(rungBar -> {
            rungBar.setY(rungBar.initY + this.getScrollMod());
            rungBar.updateVisibility();
        });
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.drawTabs(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(guiEcheladder, this.xOffset, this.yOffset, 0, 0, this.guiWidth, this.guiHeight);
        float scrollPercentage = (float)this.scroll / (float)this.maxScroll;
        guiGraphics.blit(guiEcheladder, this.xOffset + 80, (int)((float)(this.yOffset + 42) + 130.0f * (1.0f - scrollPercentage)), 0, 243, 7, 13);
        List<Component> tooltip = this.drawEffectIconsAndText(guiGraphics, this.currentRung, mouseX, mouseY);
        if (this.fromRung < this.currentRung) {
            for (int rung = Math.max(this.fromRung, this.currentRung - 4) + 1; rung <= this.currentRung; ++rung) {
                int index = rung - 1 - Math.max(this.fromRung, this.currentRung - 4);
                List<Component> newTooltip = this.drawGainedRungBonuses(guiGraphics, rung, index, mouseX, mouseY);
                if (newTooltip == null) continue;
                tooltip = newTooltip;
            }
        }
        this.drawActiveTabAndOther(guiGraphics, mouseX, mouseY);
        if (tooltip != null) {
            guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
    }

    private int getScrollMod() {
        return this.scroll * 14;
    }

    private void calculateRungAnimationStep(int speedFactor) {
        this.showLastRung = true;
        if (this.animationCycle == 0) {
            this.currentRung = animatedRung;
            if (animatedRung < ClientPlayerData.getRung()) {
                this.animatedRungs = ClientPlayerData.getRung() - animatedRung;
                this.animationCycle = 10 + this.getTicksForRungAnimation(this.animatedRungs) * speedFactor;
                animatedRung = ClientPlayerData.getRung();
            }
        } else {
            int rungTicks = this.getTicksForRungAnimation(this.animatedRungs) * speedFactor;
            if (this.animationCycle - rungTicks >= 0) {
                this.currentRung = animatedRung - this.animatedRungs;
            } else if (this.animatedRungs < 5) {
                int rung = (this.animationCycle / speedFactor + 16) / 20;
                this.currentRung = animatedRung - rung;
                if ((this.animationCycle / speedFactor + 16) % 20 >= 16) {
                    this.showLastRung = (this.animationCycle / speedFactor + 16) % 20 - 16 >= 2;
                }
            } else {
                int rung = this.animationCycle * this.animatedRungs / (65 * speedFactor) + 1;
                this.currentRung = animatedRung - rung;
            }
        }
    }

    @Nullable
    private List<Component> drawEffectIconsAndText(GuiGraphics guiGraphics, int currentRung, int mouseX, int mouseY) {
        MobEffectTextureManager sprites = this.minecraft.getMobEffectTextures();
        TextureAtlasSprite strengthSprite = sprites.get(MobEffects.DAMAGE_BOOST);
        TextureAtlasSprite healthSprite = sprites.get(MobEffects.HEALTH_BOOST);
        int textOffset = this.xOffset + 24;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(this.xOffset + 5, this.yOffset + 30, 0, 18, 18, strengthSprite);
        guiGraphics.blit(this.xOffset + 5, this.yOffset + 84, 0, 18, 18, healthSprite);
        guiGraphics.blit(PlayerStatsScreen.icons, this.xOffset + 6, this.yOffset + 139, 48, 64, 16, 16);
        guiGraphics.blit(PlayerStatsScreen.icons, this.xOffset + 5, this.yOffset + 7, 238, 16, 18, 18);
        String msg = this.title.getString();
        guiGraphics.drawString(this.font, msg, (float)(this.xOffset + 168) - (float)this.mc.font.width(msg) / 2.0f, (float)(this.yOffset + 12), 0x404040, false);
        Rung.DisplayData rungData = ClientRungData.getData(currentRung);
        int attack = (int)Math.round(100.0 * (1.0 + rungData.attributes().attackBonus()));
        guiGraphics.drawString(this.font, I18n.get((String)ATTACK, (Object[])new Object[0]), textOffset, this.yOffset + 30, 0x404040, false);
        String attackValueText = attack + "%";
        guiGraphics.drawString(this.font, attackValueText, textOffset + 2, this.yOffset + 39, 38143, false);
        double health = rungData.attributes().healthBoost() / 2.0;
        guiGraphics.drawString(this.font, I18n.get((String)HEALTH, (Object[])new Object[0]), textOffset, this.yOffset + 84, 0x404040, false);
        String healthValueText = "+" + String.format(Locale.ROOT, "%.1f", health);
        guiGraphics.drawString(this.font, healthValueText, textOffset + 2, this.yOffset + 93, 38143, false);
        guiGraphics.drawString(this.font, "=", textOffset + 1, this.yOffset + 12, 0x404040, false);
        guiGraphics.drawString(this.font, String.valueOf(ClientPlayerData.getBoondollars()), textOffset + 3 + this.mc.font.width("="), this.yOffset + 12, 38143, false);
        guiGraphics.drawString(this.font, I18n.get((String)CACHE, (Object[])new Object[0]), textOffset, this.yOffset + 138, 0x404040, false);
        guiGraphics.drawString(this.font, String.valueOf(rungData.gristCapacity()), textOffset + 2, this.yOffset + 147, 38143, false);
        if (this.mouseInBounds(mouseY, this.yOffset + 39, mouseX, textOffset + 2, this.mc.font.width(attackValueText))) {
            return ImmutableList.of((Object)Component.translatable((String)DAMAGE_UNDERLING), (Object)Component.literal((String)(Math.round((double)attack * rungData.attributes().underlingDamageMod()) + "%")));
        }
        if (this.mouseInBounds(mouseY, this.yOffset + 93, mouseX, textOffset + 2, this.mc.font.width(healthValueText))) {
            return ImmutableList.of((Object)Component.translatable((String)PROTECTION_UNDERLING), (Object)Component.literal((String)(String.format(Locale.ROOT, "%.1f", 100.0 * rungData.attributes().underlingProtectionMod()) + "%")));
        }
        return null;
    }

    @Nullable
    private List<Component> drawGainedRungBonuses(GuiGraphics guiGraphics, int rung, int index, int mouseX, int mouseY) {
        List<MutableComponent> tooltips = null;
        Rung.DisplayData prevRungData = ClientRungData.getData(rung - 1);
        Rung.DisplayData rungData = ClientRungData.getData(rung);
        int textColor = rungData.textColor();
        int bg = rungData.backgroundColor();
        int xMod = 32 * (index % 2);
        int yMod = 15 * (index / 2);
        int minX = this.xOffset + 5 + xMod;
        int maxX = this.xOffset + 35 + xMod;
        Object str = "+" + (Math.round(100.0 * rungData.attributes().attackBonus()) - Math.round(100.0 * prevRungData.attributes().attackBonus())) + "%!";
        guiGraphics.fill(minX, this.yOffset + 50 + yMod, maxX, this.yOffset + 62 + yMod, bg);
        int strX = this.xOffset + 20 + xMod - this.mc.font.width((String)str) / 2;
        int strY = this.yOffset + 52 + yMod;
        guiGraphics.drawString(this.font, (String)str, strX, strY, textColor, false);
        if (this.mouseInBounds(mouseY, strY, mouseX, strX, this.mc.font.width((String)str))) {
            int diff = (int)Math.round(100.0 * (1.0 + rungData.attributes().attackBonus()) * rungData.attributes().underlingDamageMod());
            diff = (int)((long)diff - Math.round(100.0 * (1.0 + prevRungData.attributes().attackBonus()) * prevRungData.attributes().underlingDamageMod()));
            tooltips = Collections.singletonList(Component.translatable((String)DAMAGE_UNDERLING_INCREASE, (Object[])new Object[]{diff}));
        }
        double d = (rungData.attributes().healthBoost() - prevRungData.attributes().healthBoost()) / 2.0;
        str = String.format(Locale.ROOT, "+%.1f!", d);
        guiGraphics.fill(minX, this.yOffset + 104 + yMod, maxX, this.yOffset + 116 + yMod, bg);
        strX = this.xOffset + 20 + xMod - this.mc.font.width((String)str) / 2;
        strY = this.yOffset + 106 + yMod;
        guiGraphics.drawString(this.font, (String)str, strX, strY, textColor, false);
        if (this.mouseInBounds(mouseY, strY, mouseX, strX, this.mc.font.width((String)str))) {
            int diff = (int)Math.round(1000.0 * prevRungData.attributes().underlingProtectionMod());
            diff = (int)((long)diff - Math.round(1000.0 * rungData.attributes().underlingProtectionMod()));
            tooltips = Collections.singletonList(Component.translatable((String)PROTECTION_UNDERLING_INCREASE, (Object[])new Object[]{(double)diff / 10.0}));
        }
        return tooltips;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean mouseInBounds(int mouseY, int minY, int mouseX, int minX, int xDiff) {
        if (mouseY < minY) return false;
        Objects.requireNonNull(this.mc.font);
        if (mouseY >= minY + 9) return false;
        if (mouseX < minX) return false;
        if (mouseX >= minX + xDiff) return false;
        return true;
    }

    private void updateAnimation() {
        if (this.animationCycle > 0) {
            this.animationCycle = MinestuckConfig.CLIENT.echeladderAnimation.get() != MinestuckConfig.AnimationSpeed.NOTHING ? --this.animationCycle : 0;
        }
    }

    private int getTicksForRungAnimation(int rungs) {
        if (rungs < 5) {
            return 4 + (rungs - 1) * 20;
        }
        return 65;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int i) {
        if ((keyCode == 257 || keyCode == 335) && this.animationCycle > 0) {
            this.animationCycle = 0;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, i);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0) {
            this.scroll = scrollY > 0.0 ? ++this.scroll : --this.scroll;
            this.scroll = Mth.clamp((int)this.scroll, (int)0, (int)this.maxScroll);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean mouseClicked(double xcor, double ycor, int mouseButton) {
        if (mouseButton == 0 && xcor >= (double)(this.xOffset + 80) && xcor < (double)(this.xOffset + 87)) {
            if (ycor >= (double)(this.yOffset + 35) && ycor < (double)(this.yOffset + 42)) {
                this.scroll = this.maxScroll;
                return true;
            }
            if (ycor >= (double)(this.yOffset + 185) && ycor < (double)(this.yOffset + 192)) {
                this.scroll = 0;
                return true;
            }
        }
        return super.mouseClicked(xcor, ycor, mouseButton);
    }

    private final class RungBar
    extends AbstractWidget {
        private final int initY;
        private final int rung;

        public RungBar(int initX, int initY, int width, int height, Component message, Optional<String> tooltip, int rung) {
            super(initX, initY, width, height, message);
            this.initY = initY;
            this.rung = rung;
            tooltip.ifPresent(string -> this.setTooltip(Tooltip.create((Component)Component.translatable((String)string))));
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int x = this.getX();
            int y = this.getY();
            guiGraphics.blit(guiEcheladder, x, y, 7, 242, 146, 14);
            int textColor = -1;
            int backgroundColor = ClientRungData.getData(this.rung).backgroundColor();
            if (this.rung <= EcheladderScreen.this.currentRung - (EcheladderScreen.this.showLastRung ? 0 : 1)) {
                textColor = ClientRungData.getData(this.rung).textColor();
                guiGraphics.fill(x, y + 2, x + 146, y + 14, backgroundColor);
            } else if (this.rung == EcheladderScreen.this.currentRung + 1 && EcheladderScreen.this.animationCycle == 0) {
                float brightness = (float)((backgroundColor >> 16 & 0xFF) + (backgroundColor >> 8 & 0xFF) + (backgroundColor & 0xFF)) / 765.0f;
                boolean isDark = (double)brightness < 0.2;
                guiGraphics.fill(x, y + 12, x + (int)(146.0f * ClientPlayerData.getRungProgress()), y + 14, isDark ? -1 : backgroundColor);
            }
            guiGraphics.drawString(EcheladderScreen.this.font, this.getMessage(), x + 73 - EcheladderScreen.this.mc.font.width((FormattedText)this.getMessage()) / 2, y + 4, textColor, false);
        }

        public void updateVisibility() {
            this.visible = this.rung >= EcheladderScreen.this.scroll && this.rung <= EcheladderScreen.this.scroll + 12;
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

