/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.playerStats;

import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.client.gui.playerStats.PlayerStatsScreen;
import com.mraof.minestuck.computer.editmode.ClientEditmodeData;
import com.mraof.minestuck.player.ClientPlayerData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

public class GristCacheScreen
extends PlayerStatsScreen {
    public static final String TITLE = "minestuck.grist_cache";
    private static final ResourceLocation guiGristcache = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/grist_cache.png");
    private int page = 0;
    private Button previousButton;
    private Button nextButton;

    public GristCacheScreen() {
        super((Component)Component.translatable((String)TITLE));
        this.guiWidth = 226;
        this.guiHeight = 190;
    }

    @Override
    public void init() {
        super.init();
        this.previousButton = new ExtendedButton(this.xOffset + 8, this.yOffset + 8, 16, 16, (Component)Component.literal((String)"<"), button -> this.prevPage());
        this.nextButton = new ExtendedButton(this.xOffset + this.guiWidth - 24, this.yOffset + 8, 16, 16, (Component)Component.literal((String)">"), button -> this.nextPage());
        this.addRenderableWidget((GuiEventListener)this.nextButton);
        this.addRenderableWidget((GuiEventListener)this.previousButton);
        this.previousButton.visible = false;
        if (GristTypes.REGISTRY.size() <= 21) {
            this.nextButton.visible = false;
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.drawTabs(guiGraphics);
        guiGraphics.blit(guiGristcache, this.xOffset, this.yOffset, 0, 0, this.guiWidth, this.guiHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        String cacheMessage = ClientEditmodeData.isInEditmode() || ClientPlayerData.getTitle() == null ? this.getTitle().getString() : ClientPlayerData.getTitle().asTextComponent().getString();
        guiGraphics.drawString(this.font, cacheMessage, (float)this.width / 2.0f - (float)this.mc.font.width(cacheMessage) / 2.0f, (float)(this.yOffset + 12), 0x404040, false);
        this.drawActiveTabAndOther(guiGraphics, mouseX, mouseY);
        this.drawGrist(guiGraphics, this.xOffset, this.yOffset, mouseX, mouseY, this.page);
    }

    private void prevPage() {
        if (this.page > 0) {
            --this.page;
            if (this.page == 0) {
                this.previousButton.visible = false;
            }
            this.nextButton.visible = true;
        }
    }

    private void nextPage() {
        int maxPage = (GristTypes.REGISTRY.size() - 1) / 21;
        if (this.page < maxPage) {
            ++this.page;
            if (this.page == maxPage) {
                this.nextButton.visible = false;
            }
            this.previousButton.visible = true;
        }
    }
}

