/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.playerStats;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.client.gui.EditmodeSettingsScreen;
import com.mraof.minestuck.client.gui.playerStats.PlayerStatsContainerScreen;
import com.mraof.minestuck.inventory.EditmodeMenu;
import com.mraof.minestuck.network.editmode.EditmodeInventoryPackets;
import java.time.LocalDate;
import java.time.Month;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class InventoryEditmodeScreen
extends PlayerStatsContainerScreen<EditmodeMenu> {
    public static final String TITLE = "minestuck.deploy_list";
    private static final ResourceLocation GUI_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/gui_inv_editmode.png");
    public static final ResourceLocation SETTINGS_ICON = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/desktop_icon/settings.png");
    private static final int LEFT_ARROW_X = 7;
    private static final int RIGHT_ARROW_X = 151;
    private static final int ARROW_Y = 23;
    private static final int SETTINGS_X = 80;
    private static final int SETTINGS_Y = 54;
    public static final int ARROW_SIZE = 18;
    public static final int SETTINGS_SIZE = 16;
    public boolean more;
    public boolean less;
    private Player player;

    public InventoryEditmodeScreen(int windowId, Inventory playerInventory) {
        super(new EditmodeMenu(windowId, playerInventory), playerInventory, (Component)Component.translatable((String)TITLE));
        this.guiWidth = 176;
        this.guiHeight = 98;
        this.player = playerInventory.player;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (InventoryEditmodeScreen.overtopSettingsIconBounds(mouseX, mouseY, this.xOffset, this.yOffset, 80, 54)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"Editmode settings"), mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float par1, int xcor, int ycor) {
        this.drawTabs(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(GUI_BACKGROUND, this.xOffset, this.yOffset, 0, 0, this.guiWidth, this.guiHeight);
        LocalDate localdate = LocalDate.now();
        int d = localdate.getDayOfMonth();
        Month m = localdate.getMonth();
        boolean b1 = (Boolean)MinestuckConfig.SERVER.hardMode.get();
        boolean b2 = !b1 && (m == Month.APRIL && d == 13 || m == Month.JUNE && d == 12 || m == Month.OCTOBER && d == 25 || m == Month.NOVEMBER && d == 11 || m == Month.NOVEMBER && d == 27);
        guiGraphics.blit(GUI_BACKGROUND, this.xOffset + 7, this.yOffset + 23, this.guiWidth + (b2 ? 36 : 0), (this.less ? 0 : 18) + (b1 ? 36 : 0), 18, 18);
        guiGraphics.blit(GUI_BACKGROUND, this.xOffset + 151, this.yOffset + 23, this.guiWidth + 18 + (b2 ? 36 : 0), (this.more ? 0 : 18) + (b1 ? 36 : 0), 18, 18);
        this.drawActiveTabAndIcons(guiGraphics);
        guiGraphics.blit(SETTINGS_ICON, this.xOffset + 80, this.yOffset + 54, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    @Override
    public boolean mouseClicked(double xcor, double ycor, int mouseButton) {
        boolean clickedInArrowIconYRange;
        if (InventoryEditmodeScreen.overtopSettingsIconBounds(xcor, ycor, this.xOffset, this.yOffset, 80, 54)) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.minecraft.setScreen(null);
            this.minecraft.setScreen((Screen)new EditmodeSettingsScreen(this.player));
        }
        boolean bl = clickedInArrowIconYRange = ycor >= (double)(this.yOffset + 23) && ycor < (double)(this.yOffset + 23 + 18);
        if (clickedInArrowIconYRange) {
            boolean clickedInRightArrowXRange;
            EditmodeInventoryPackets.Scroll packet = null;
            boolean clickedInLeftArrowXRange = this.less && xcor >= (double)(this.xOffset + 7) && xcor < (double)(this.xOffset + 7 + 18);
            boolean bl2 = clickedInRightArrowXRange = this.more && xcor >= (double)(this.xOffset + 151) && xcor < (double)(this.xOffset + 151 + 18);
            if (clickedInLeftArrowXRange) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                packet = new EditmodeInventoryPackets.Scroll(false);
            } else if (clickedInRightArrowXRange) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                packet = new EditmodeInventoryPackets.Scroll(true);
            }
            if (packet != null) {
                PacketDistributor.sendToServer(packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return super.mouseClicked(xcor, ycor, mouseButton);
    }

    public static boolean overtopSettingsIconBounds(double xPos, double yPos, int xOffset, int yOffset, int SETTINGS_X, int SETTINGS_Y) {
        boolean inYRange = yPos >= (double)(yOffset + SETTINGS_Y) && yPos < (double)(yOffset + SETTINGS_Y + 16);
        boolean inXRange = xPos >= (double)(xOffset + SETTINGS_X) && xPos < (double)(xOffset + SETTINGS_X + 16);
        return inYRange && inXRange;
    }
}

