/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.playerStats;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.client.gui.playerStats.DataCheckerScreen;
import com.mraof.minestuck.client.gui.playerStats.PlayerStatsScreen;
import com.mraof.minestuck.client.util.MSKeyHandler;
import com.mraof.minestuck.computer.editmode.ClientEditmodeData;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.skaianet.client.SkaiaClient;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class PlayerStatsContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected int guiWidth;
    protected int guiHeight;
    protected int xOffset;
    protected int yOffset;
    private boolean mode = !ClientEditmodeData.isInEditmode();

    public PlayerStatsContainerScreen(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    public void init() {
        super.init();
        this.minecraft.player.containerMenu = this.menu;
        this.xOffset = (this.width - this.guiWidth) / 2;
        this.topPos = this.yOffset = (this.height - this.guiHeight + 32 - 4) / 2;
        this.leftPos = this.xOffset;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void drawTabs(GuiGraphics guiGraphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.mode) {
            for (PlayerStatsScreen.NormalGuiType type : PlayerStatsScreen.NormalGuiType.values()) {
                int i;
                if (type == PlayerStatsScreen.normalTab || type.reqMedium() && !SkaiaClient.hasPlayerEntered() && !this.minecraft.gameMode.hasInfiniteItems()) continue;
                guiGraphics.blit(PlayerStatsScreen.icons, this.xOffset + i * 30, this.yOffset - 32 + 4, (i = type.ordinal()) == 0 ? 0 : 28, 0, 28, 32);
            }
        } else {
            for (PlayerStatsScreen.EditmodeGuiType type : PlayerStatsScreen.EditmodeGuiType.values()) {
                int i;
                if (type == PlayerStatsScreen.editmodeTab) continue;
                guiGraphics.blit(PlayerStatsScreen.icons, this.xOffset + i * 30, this.yOffset - 32 + 4, (i = type.ordinal()) == 0 ? 0 : 28, 0, 28, 32);
            }
        }
        if (ClientPlayerData.hasDataCheckerAccess()) {
            guiGraphics.blit(PlayerStatsScreen.icons, this.xOffset + this.guiWidth - 28, this.yOffset - 32 + 4, 56, 0, 28, 32);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.drawTabTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void drawActiveTabAndIcons(GuiGraphics guiGraphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int index = (this.mode ? PlayerStatsScreen.normalTab : PlayerStatsScreen.editmodeTab).ordinal();
        guiGraphics.blit(PlayerStatsScreen.icons, this.xOffset + index * 30, this.yOffset - 32 + 4, index == 0 ? 0 : 28, 32, 28, 32);
        for (int i = 0; i < (this.mode ? PlayerStatsScreen.NormalGuiType.values() : PlayerStatsScreen.EditmodeGuiType.values()).length; ++i) {
            if (this.mode && PlayerStatsScreen.NormalGuiType.values()[i].reqMedium() && !SkaiaClient.hasPlayerEntered() && !this.minecraft.gameMode.hasInfiniteItems()) continue;
            guiGraphics.blit(PlayerStatsScreen.icons, this.xOffset + 6 + 30 * i, this.yOffset - 32 + 4 + 8, i * 16, 64 + (this.mode ? 0 : 16), 16, 16);
        }
        if (ClientPlayerData.hasDataCheckerAccess()) {
            guiGraphics.blit(PlayerStatsScreen.icons, this.xOffset + this.guiWidth + 6 - 28, this.yOffset - 32 + 4 + 8, 80, 64, 16, 16);
        }
    }

    protected void drawTabTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RenderSystem.disableDepthTest();
        if (mouseY < this.yOffset && mouseY > this.yOffset - 32 + 4) {
            for (int i = 0; i < (this.mode ? PlayerStatsScreen.NormalGuiType.values() : PlayerStatsScreen.EditmodeGuiType.values()).length && mouseX >= this.xOffset + i * 30; ++i) {
                if (mouseX >= this.xOffset + i * 30 + 28 || this.mode && PlayerStatsScreen.NormalGuiType.values()[i].reqMedium() && !SkaiaClient.hasPlayerEntered() && !this.minecraft.gameMode.hasInfiniteItems()) continue;
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)(this.mode ? PlayerStatsScreen.NormalGuiType.values()[i].name : PlayerStatsScreen.EditmodeGuiType.values()[i].name)), mouseX, mouseY);
            }
        }
        RenderSystem.enableDepthTest();
    }

    public boolean mouseClicked(double xcor, double ycor, int mouseButton) {
        if (mouseButton == 0 && ycor < (double)((this.height - this.guiHeight + 32 - 4) / 2) && ycor > (double)((this.height - this.guiHeight - 32 + 4) / 2)) {
            for (int i = 0; i < (this.mode ? PlayerStatsScreen.NormalGuiType.values() : PlayerStatsScreen.EditmodeGuiType.values()).length && !(xcor < (double)(this.xOffset + i * 30)); ++i) {
                if (!(xcor < (double)(this.xOffset + i * 30 + 28))) continue;
                if (this.mode && PlayerStatsScreen.NormalGuiType.values()[i].reqMedium() && !SkaiaClient.hasPlayerEntered() && this.minecraft.gameMode.hasMissTime()) {
                    return true;
                }
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                if (i != (this.mode ? PlayerStatsScreen.normalTab : PlayerStatsScreen.editmodeTab).ordinal()) {
                    if (this.mode) {
                        PlayerStatsScreen.normalTab = PlayerStatsScreen.NormalGuiType.values()[i];
                    } else {
                        PlayerStatsScreen.editmodeTab = PlayerStatsScreen.EditmodeGuiType.values()[i];
                    }
                    PlayerStatsScreen.openGui(true);
                }
                return true;
            }
            if (ClientPlayerData.hasDataCheckerAccess() && xcor < (double)(this.xOffset + this.guiWidth) && xcor >= (double)(this.xOffset + this.guiWidth - 28)) {
                this.minecraft.setScreen((Screen)new DataCheckerScreen());
                return true;
            }
        }
        return super.mouseClicked(xcor, ycor, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int i) {
        if (MSKeyHandler.statKey.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.minecraft.setScreen(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, i);
    }
}

