/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.playerStats;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.client.gui.MinestuckScreen;
import com.mraof.minestuck.client.gui.playerStats.AtheneumScreen;
import com.mraof.minestuck.client.gui.playerStats.CaptchaDeckScreen;
import com.mraof.minestuck.client.gui.playerStats.DataCheckerScreen;
import com.mraof.minestuck.client.gui.playerStats.EcheladderScreen;
import com.mraof.minestuck.client.gui.playerStats.GristCacheScreen;
import com.mraof.minestuck.client.gui.playerStats.InventoryEditmodeScreen;
import com.mraof.minestuck.client.gui.playerStats.PlayerStatsContainerScreen;
import com.mraof.minestuck.client.gui.playerStats.StrifeSpecibusScreen;
import com.mraof.minestuck.client.util.MSKeyHandler;
import com.mraof.minestuck.computer.editmode.ClientEditmodeData;
import com.mraof.minestuck.network.MiscContainerPacket;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.skaianet.client.SkaiaClient;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public abstract class PlayerStatsScreen
extends MinestuckScreen {
    public static final int WINDOW_ID_START = 105;
    public static final ResourceLocation icons = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/icons.png");
    static final int tabWidth = 28;
    static final int tabHeight = 32;
    static final int tabOverlap = 4;
    public static NormalGuiType normalTab = NormalGuiType.CAPTCHA_DECK;
    public static EditmodeGuiType editmodeTab = EditmodeGuiType.DEPLOY_LIST;
    public Minecraft mc;
    protected int guiWidth;
    protected int guiHeight;
    protected int xOffset;
    protected int yOffset;
    private boolean mode = !ClientEditmodeData.isInEditmode();

    public PlayerStatsScreen(Component titleIn) {
        super(titleIn);
    }

    public void init() {
        super.init();
        this.xOffset = (this.width - this.guiWidth) / 2;
        this.yOffset = (this.height - this.guiHeight + 32 - 4) / 2;
        this.mc = Minecraft.getInstance();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void drawTabs(GuiGraphics guiGraphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.mode) {
            for (NormalGuiType type : NormalGuiType.values()) {
                int i;
                if (type == normalTab || type.reqMedium() && !SkaiaClient.hasPlayerEntered() && !this.mc.gameMode.hasInfiniteItems()) continue;
                guiGraphics.blit(icons, this.xOffset + i * 30, this.yOffset - 32 + 4, (i = type.ordinal()) == 0 ? 0 : 28, 0, 28, 32);
            }
        } else {
            for (EditmodeGuiType type : EditmodeGuiType.values()) {
                int i;
                if (type == editmodeTab) continue;
                guiGraphics.blit(icons, this.xOffset + i * 30, this.yOffset - 32 + 4, (i = type.ordinal()) == 0 ? 0 : 28, 0, 28, 32);
            }
        }
        if (ClientPlayerData.hasDataCheckerAccess()) {
            guiGraphics.blit(icons, this.xOffset + this.guiWidth - 28, this.yOffset - 32 + 4, 56, 0, 28, 32);
        }
    }

    protected void drawActiveTabAndOther(GuiGraphics guiGraphics, int xcor, int ycor) {
        int i;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int index = (this.mode ? normalTab : editmodeTab).ordinal();
        guiGraphics.blit(icons, this.xOffset + index * 30, this.yOffset - 32 + 4, index == 0 ? 0 : 28, 32, 28, 32);
        for (i = 0; i < (this.mode ? NormalGuiType.values() : EditmodeGuiType.values()).length; ++i) {
            if (this.mode && NormalGuiType.values()[i].reqMedium() && !SkaiaClient.hasPlayerEntered() && !this.mc.gameMode.hasInfiniteItems()) continue;
            guiGraphics.blit(icons, this.xOffset + 6 + 30 * i, this.yOffset - 32 + 4 + 8, i * 16, 64 + (this.mode ? 0 : 16), 16, 16);
        }
        if (ClientPlayerData.hasDataCheckerAccess()) {
            guiGraphics.blit(icons, this.xOffset + this.guiWidth + 6 - 28, this.yOffset - 32 + 4 + 8, 80, 64, 16, 16);
        }
        if (ycor < this.yOffset && ycor > this.yOffset - 32 + 4) {
            for (i = 0; i < (this.mode ? NormalGuiType.values() : EditmodeGuiType.values()).length && xcor >= this.xOffset + i * 30; ++i) {
                if (xcor >= this.xOffset + i * 30 + 28 || this.mode && NormalGuiType.values()[i].reqMedium() && !SkaiaClient.hasPlayerEntered() && !this.mc.gameMode.hasInfiniteItems()) continue;
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)(this.mode ? NormalGuiType.values()[i].name : EditmodeGuiType.values()[i].name)), xcor, ycor);
            }
        }
    }

    public boolean mouseClicked(double xcor, double ycor, int mouseButton) {
        if (mouseButton == 0 && ycor < (double)((this.height - this.guiHeight + 32 - 4) / 2) && ycor > (double)((this.height - this.guiHeight - 32 + 4) / 2)) {
            for (int i = 0; i < (this.mode ? NormalGuiType.values() : EditmodeGuiType.values()).length && !(xcor < (double)(this.xOffset + i * 30)); ++i) {
                if (!(xcor < (double)(this.xOffset + i * 30 + 28))) continue;
                if (this.mode && NormalGuiType.values()[i].reqMedium() && !SkaiaClient.hasPlayerEntered() && this.mc.gameMode.hasMissTime()) {
                    return true;
                }
                this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                if (i != (this.mode ? normalTab : editmodeTab).ordinal()) {
                    if (this.mode) {
                        normalTab = NormalGuiType.values()[i];
                    } else {
                        editmodeTab = EditmodeGuiType.values()[i];
                    }
                    PlayerStatsScreen.openGui(true);
                }
                return true;
            }
            if (ClientPlayerData.hasDataCheckerAccess() && xcor < (double)(this.xOffset + this.guiWidth) && xcor >= (double)(this.xOffset + this.guiWidth - 28)) {
                this.mc.setScreen((Screen)new DataCheckerScreen());
                return true;
            }
        }
        return super.mouseClicked(xcor, ycor, mouseButton);
    }

    public static void openGui(boolean reload) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player.isSpectator()) {
            if (ClientPlayerData.hasDataCheckerAccess()) {
                if (mc.screen instanceof DataCheckerScreen) {
                    mc.setScreen(null);
                } else {
                    mc.setScreen((Screen)new DataCheckerScreen());
                }
            }
            return;
        }
        if (reload || mc.screen == null) {
            if (mc.screen instanceof AbstractContainerScreen) {
                mc.player.connection.send((Packet)new ServerboundContainerClosePacket(mc.player.containerMenu.containerId));
                mc.player.containerMenu.setCarried(ItemStack.EMPTY);
            }
            if (ClientEditmodeData.isInEditmode() ? PlayerStatsScreen.editmodeTab.isContainer : PlayerStatsScreen.normalTab.isContainer) {
                int ordinal = (ClientEditmodeData.isInEditmode() ? editmodeTab : normalTab).ordinal();
                int windowId = 105 + ordinal;
                PlayerStatsContainerScreen containerScreen = (PlayerStatsContainerScreen)(ClientEditmodeData.isInEditmode() ? editmodeTab.createGuiInstance(windowId) : normalTab.createGuiInstance(windowId));
                mc.setScreen((Screen)containerScreen);
                if (mc.screen == containerScreen) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MiscContainerPacket(ordinal, ClientEditmodeData.isInEditmode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                mc.setScreen(ClientEditmodeData.isInEditmode() ? editmodeTab.createGuiInstance() : normalTab.createGuiInstance());
            }
        } else if (mc.screen instanceof PlayerStatsScreen || mc.screen instanceof PlayerStatsContainerScreen) {
            mc.setScreen(null);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int i) {
        if (MSKeyHandler.statKey.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.mc.setScreen(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, i);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        normalTab = NormalGuiType.CAPTCHA_DECK;
        editmodeTab = EditmodeGuiType.DEPLOY_LIST;
        DataCheckerScreen.activeComponent = null;
        EcheladderScreen.lastRung = -1;
        EcheladderScreen.animatedRung = 0;
    }

    public static enum NormalGuiType {
        CAPTCHA_DECK(CaptchaDeckScreen::new, "minestuck.captcha_deck", false),
        STRIFE_SPECIBUS(StrifeSpecibusScreen::new, "minestuck.strife_specibus", false),
        ECHELADDER(EcheladderScreen::new, "minestuck.echeladder", false),
        GRIST_CACHE(GristCacheScreen::new, "minestuck.grist_cache", true);

        final Supplier<? extends Screen> factory;
        final BiFunction<Integer, Inventory, ? extends AbstractContainerScreen<?>> factory2;
        final String name;
        final boolean isContainer;
        final boolean reqMedium;

        private NormalGuiType(Supplier<? extends Screen> factory, String name, boolean reqMedium) {
            this.factory = factory;
            this.factory2 = null;
            this.name = name;
            this.isContainer = false;
            this.reqMedium = reqMedium;
        }

        private NormalGuiType(BiFunction<Integer, Inventory, ? extends AbstractContainerScreen<?>> factory, String name, boolean reqMedium) {
            this.factory = null;
            this.factory2 = factory;
            this.name = name;
            this.isContainer = true;
            this.reqMedium = reqMedium;
        }

        public Screen createGuiInstance() {
            return this.factory.get();
        }

        public Screen createGuiInstance(int windowId) {
            return (Screen)this.factory2.apply(windowId, Minecraft.getInstance().player.getInventory());
        }

        public boolean reqMedium() {
            return this.reqMedium;
        }
    }

    public static enum EditmodeGuiType {
        DEPLOY_LIST(InventoryEditmodeScreen::new, "minestuck.deploy_list"),
        GRIST_CACHE(GristCacheScreen::new, "minestuck.grist_cache"),
        ATHENEUM(AtheneumScreen::new, "minestuck.atheneum");

        final Supplier<? extends Screen> factory;
        final BiFunction<Integer, Inventory, ? extends AbstractContainerScreen<?>> factory2;
        final String name;
        final boolean isContainer;

        private EditmodeGuiType(Supplier<? extends Screen> factory, String name) {
            this.factory = factory;
            this.factory2 = null;
            this.name = name;
            this.isContainer = false;
        }

        private EditmodeGuiType(BiFunction<Integer, Inventory, ? extends AbstractContainerScreen<?>> factory, String name) {
            this.factory = null;
            this.factory2 = factory;
            this.name = name;
            this.isContainer = true;
        }

        public Screen createGuiInstance() {
            return this.factory.get();
        }

        public Screen createGuiInstance(int windowId) {
            return (Screen)this.factory2.apply(windowId, Minecraft.getInstance().player.getInventory());
        }
    }
}

