/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.playerStats;

import com.mraof.minestuck.client.gui.playerStats.PlayerStatsScreen;
import com.mraof.minestuck.player.KindAbstratusList;
import com.mraof.minestuck.player.KindAbstratusType;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public class StrifeSpecibusScreen
extends PlayerStatsScreen {
    public static final String TITLE = "minestuck.strife_specibus";
    public static final String KIND_ABSTRATUS = "minestuck.kind_abstratus";
    private static final ResourceLocation guiStrifeSelector = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/strife_selector.png");
    private static final int columnWidth = 70;
    private static final int columns = 3;

    public StrifeSpecibusScreen() {
        super((Component)Component.translatable((String)TITLE));
        this.guiWidth = 228;
        this.guiHeight = 150;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.drawTabs(guiGraphics);
        guiGraphics.blit(guiStrifeSelector, this.xOffset, this.yOffset, 0, 0, this.guiWidth, this.guiHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        String message = "This feature isn't implemented yet.";
        guiGraphics.drawString(this.font, message, (float)this.width / 2.0f - (float)this.mc.font.width(message) / 2.0f, (float)(this.yOffset + 12), 0x404040, false);
        int i = 0;
        for (KindAbstratusType type : KindAbstratusList.getTypeList()) {
            String typeName = type.getDisplayName().getString();
            int xPos = this.xOffset + 9 + 70 * (i % 3 + 1) - this.mc.font.width(typeName);
            Objects.requireNonNull(this.mc.font);
            int yPos = this.yOffset + 35 + (9 + 1) * (i / 3);
            Objects.requireNonNull(this.mc.font);
            if (!this.isPointInRegion(this.xOffset + 9 + 70 * (i % 3) + 1, yPos - 1, 69, 9 + 1, mouseX, mouseY)) {
                guiGraphics.drawString(this.font, typeName, xPos, yPos, 0xFFFFFF, false);
            } else {
                Objects.requireNonNull(this.mc.font);
                guiGraphics.fill(this.xOffset + 9 + 70 * (i % 3) + 1, yPos - 1, this.xOffset + 9 + 70 * (i % 3 + 1), yPos + 9, -5263441);
                guiGraphics.drawString(this.font, typeName, xPos, yPos, 0, false);
            }
            ++i;
        }
        this.drawActiveTabAndOther(guiGraphics, mouseX, mouseY);
    }
}

