/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.toasts;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.client.util.GuiUtil;
import com.mraof.minestuck.network.GristToastPacket;
import com.mraof.minestuck.player.ClientPlayerData;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GristToast
implements Toast {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/toasts.png");
    private static final int GRIST_VIAL_OUTLINE_OFFSETX = 29;
    private static final int GRIST_VIAL_OUTLINE_OFFSETY = 13;
    private static final int GRIST_VIAL_OUTLINE_WIDTH = 101;
    private static final int GRIST_VIAL_OUTLINE_HEIGHT = 10;
    private static final int GRIST_VIAL_INSIDE_OFFSETX = 31;
    private static final int GRIST_VIAL_INSIDE_OFFSETY = 15;
    private static final int GRIST_VIAL_INSIDE_WIDTH = 97;
    private static final int GRIST_VIAL_INSIDE_HEIGHT = 6;
    private static final long DISPLAY_TIME = 5000L;
    private final GristType gristType;
    private long difference;
    private long cacheLimit;
    private long gristCache;
    private final GristHelper.EnumSource source;
    private final boolean increase;
    private long lastChanged;
    private boolean changed;
    private int animationTimer;

    public GristToast(GristType pType, long pDifference, GristHelper.EnumSource pSource, boolean pIncrease, long pCacheLimit, long pGristCache) {
        this.gristType = pType;
        this.difference = pDifference;
        this.source = pSource;
        this.increase = pIncrease;
        this.cacheLimit = pCacheLimit;
        this.gristCache = pGristCache;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        int animationOffset;
        if (this.changed) {
            this.animationTimer = this.gristCache >= this.cacheLimit ? 20 : 0;
            this.lastChanged = pTimeSinceLastVisible;
            this.changed = false;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(TEXTURE, 0, 0, 0, 0, 160, 32);
        switch (this.source) {
            case CLIENT: {
                guiGraphics.blit(TEXTURE, 133, 7, 196, 0, 20, 20);
                break;
            }
            case SERVER: {
                guiGraphics.blit(TEXTURE, 133, 7, 196, 20, 20, 20);
                break;
            }
            case SENDGRIST: {
                guiGraphics.blit(TEXTURE, 133, 7, 216, 0, 20, 20);
                break;
            }
            case CONSOLE: {
                guiGraphics.blit(TEXTURE, 133, 7, 216, 20, 20, 20);
            }
        }
        PoseStack posestack = guiGraphics.pose();
        posestack.pushPose();
        posestack.scale(1.3333334f, 1.3333334f, 1.0f);
        guiGraphics.blit(this.gristType.getIcon(), 5, 4, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        posestack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n = animationOffset = this.animationTimer / 2 <= 5 ? this.animationTimer / 2 % 5 : 5 - this.animationTimer / 2 % 5;
        if (this.source == GristHelper.EnumSource.GUTTER) {
            guiGraphics.blit(TEXTURE, 0, 17 - animationOffset, 176, 60, 20, 20);
            guiGraphics.blit(TEXTURE, 40, 24 - animationOffset, 176, 80, 67, 8);
        }
        double gristFraction = Math.min(1.0, (double)this.gristCache / (double)this.cacheLimit);
        guiGraphics.fill(31, 15, 31 + (int)(97.0 * gristFraction), 21, -15092753);
        guiGraphics.blit(TEXTURE, 29, 13, 0, 128, 101, 10);
        this.drawText(guiGraphics, pToastComponent.getMinecraft().font);
        if (this.animationTimer > 0) {
            this.animationTimer = -1;
        }
        return pTimeSinceLastVisible - this.lastChanged >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    private void drawText(GuiGraphics guiGraphics, Font font) {
        int textColor = this.increase ? 443164 : 0xFF0000;
        guiGraphics.drawString(font, "(%s%s)".formatted(this.increase ? "+" : "-", GuiUtil.addSuffix(this.difference)), 30.0f, 5.0f, textColor, false);
        if (this.source != GristHelper.EnumSource.GUTTER) {
            String cacheText = GuiUtil.addSuffix(this.gristCache);
            String limitText = " / " + GuiUtil.addSuffix(this.cacheLimit);
            int fullBottomTextWidth = font.width(cacheText) + font.width(limitText);
            if (fullBottomTextWidth <= 97) {
                float xLeft = 31.0f + (float)(97 - fullBottomTextWidth) / 2.0f;
                guiGraphics.drawString(font, cacheText, xLeft, 24.0f, textColor, false);
                guiGraphics.drawString(font, limitText, xLeft + (float)font.width(cacheText), 24.0f, 0, false);
            } else {
                guiGraphics.drawString(font, cacheText, 31.0f + (float)(97 - font.width(cacheText)) / 2.0f, 24.0f, textColor, false);
            }
        }
    }

    private void addGrist(long difference, long newLimit, long newCacheAmount) {
        this.difference += difference;
        this.cacheLimit = newLimit;
        this.gristCache = newCacheAmount;
        this.changed = true;
    }

    public static void addOrUpdate(ToastComponent toastGui, GristType type, long difference, GristHelper.EnumSource source, boolean isIncrease, long cacheLimit, long cacheAmount) {
        GristToast gristToast = (GristToast)toastGui.getToast(GristToast.class, (Object)new Token(type, source, isIncrease));
        if (gristToast == null) {
            toastGui.addToast((Toast)new GristToast(type, difference, source, isIncrease, cacheLimit, cacheAmount));
        } else {
            gristToast.addGrist(difference, cacheLimit, cacheAmount);
        }
    }

    public static void handlePacket(GristToastPacket packet) {
        ClientPlayerData.ClientCache cache = ClientPlayerData.getGristCache(packet.isCacheOwner() ? ClientPlayerData.CacheSource.PLAYER : ClientPlayerData.CacheSource.EDITMODE);
        GristHelper.EnumSource source = packet.source();
        ToastComponent toasts = Minecraft.getInstance().getToasts();
        for (GristAmount pair : packet.gristValue().asAmounts()) {
            GristType type = pair.type();
            long difference = pair.amount();
            long total = cache.set().getGrist(type);
            if (difference == 0L) continue;
            if (difference >= 0L) {
                GristToast.addOrUpdate(toasts, type, difference, source, true, cache.limit(), total);
                continue;
            }
            GristToast.addOrUpdate(toasts, type, Math.abs(difference), source, false, cache.limit(), total);
        }
    }

    public Token getToken() {
        return new Token(this.gristType, this.source, this.increase);
    }

    private record Token(GristType type, GristHelper.EnumSource source, boolean isIncrease) {
    }
}

