/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.model.entity;

import com.mraof.minestuck.entity.carapacian.BishopEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BishopModel<T extends BishopEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart hatKnob;
    private final ModelPart head;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private int heldItemLeft;
    private int heldItemRight;

    public BishopModel(ModelPart root) {
        this.root = root;
        this.hatKnob = root.getChild("hat_knob");
        this.head = root.getChild("head");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
        this.leftArm = root.getChild("left_arm");
        this.rightArm = root.getChild("right_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        float offsetY = -46.0f;
        root.addOrReplaceChild("hat_knob", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -34.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)(33.0f + offsetY), (float)-4.0f));
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -30.0f, -8.0f, 16.0f, 30.0f, 16.0f), PartPose.offset((float)0.0f, (float)(33.0f + offsetY), (float)-4.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 46).addBox(-15.0f, 0.0f, -10.0f, 30.0f, 32.0f, 20.0f), PartPose.offset((float)0.0f, (float)(29.0f + offsetY), (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(64, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 24.0f, 6.0f), PartPose.offset((float)-15.0f, (float)(31.0f + offsetY), (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(64, 0).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 24.0f, 6.0f), PartPose.offset((float)15.0f, (float)(31.0f + offsetY), (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(88, 0).addBox(-4.0f, 0.0f, -5.0f, 6.0f, 15.0f, 8.0f), PartPose.offset((float)-10.0f, (float)(55.0f + offsetY), (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(88, 0).mirror().addBox(-4.0f, 0.0f, -5.0f, 6.0f, 15.0f, 8.0f), PartPose.offset((float)10.0f, (float)(55.0f + offsetY), (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = (headPitch + 20.0f) / 57.295776f;
        this.hatKnob.yRot = this.head.yRot;
        this.hatKnob.xRot = this.head.xRot;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        if (this.heldItemLeft != 0) {
            this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.31415927f * (float)this.heldItemLeft;
        }
        if (this.heldItemRight != 0) {
            this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.31415927f * (float)this.heldItemRight;
        }
    }
}

