/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.model.entity;

import com.mraof.minestuck.entity.FrogEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class FrogModel<T extends FrogEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart left_eye;
    private final ModelPart right_eye;
    private final ModelPart left_top_leg;
    private final ModelPart right_top_leg;
    private final ModelPart left_bottom_leg;
    private final ModelPart right_bottom_leg;
    private final ModelPart left_foot;
    private final ModelPart right_foot;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private float jumpRotation;

    public FrogModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.left_eye = root.getChild("left_eye");
        this.right_eye = root.getChild("right_eye");
        this.left_top_leg = root.getChild("left_top_leg");
        this.right_top_leg = root.getChild("right_top_leg");
        this.left_bottom_leg = root.getChild("left_bottom_leg");
        this.right_bottom_leg = root.getChild("right_bottom_leg");
        this.left_foot = root.getChild("left_foot");
        this.right_foot = root.getChild("right_foot");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -2.0f, -8.0f, 6.0f, 5.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)8.0f, (float)-0.34906587f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 0).addBox(-3.5f, -4.0f, -5.0f, 7.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)1.0f));
        root.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(52, 5).addBox(1.5f, -5.0f, -4.5f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)1.0f));
        root.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(52, 5).addBox(-4.5f, -5.0f, -4.5f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)1.0f));
        root.addOrReplaceChild("left_top_leg", CubeListBuilder.create().texOffs(30, 16).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 5.0f), PartPose.offsetAndRotation((float)3.0f, (float)17.5f, (float)3.7f, (float)0.27314404f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("right_top_leg", CubeListBuilder.create().texOffs(16, 16).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 5.0f), PartPose.offsetAndRotation((float)-3.0f, (float)17.5f, (float)3.7f, (float)0.27314404f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("left_bottom_leg", CubeListBuilder.create().texOffs(28, 24).addBox(-1.1f, 3.5f, -4.3f, 2.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)3.0f, (float)17.5f, (float)3.7f, (float)1.0471976f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("right_bottom_leg", CubeListBuilder.create().texOffs(44, 24).addBox(-0.9f, 3.5f, -4.3f, 2.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)-3.0f, (float)17.5f, (float)3.7f, (float)1.0471976f, (float)0.0f, (float)0.0034906587f));
        root.addOrReplaceChild("left_foot", CubeListBuilder.create().texOffs(14, 26).addBox(-1.1f, 5.4f, -2.5f, 2.0f, 1.0f, 5.0f), PartPose.offset((float)3.0f, (float)17.5f, (float)3.7f));
        root.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(0, 26).addBox(-0.9f, 5.4f, -2.5f, 2.0f, 1.0f, 5.0f), PartPose.offset((float)-3.0f, (float)17.5f, (float)3.7f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(8, 15).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.offsetAndRotation((float)3.0f, (float)17.0f, (float)1.0f, (float)-0.19198623f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 15).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.offsetAndRotation((float)-3.0f, (float)17.0f, (float)1.0f, (float)-0.19198623f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)((FrogEntity)((Object)entityIn)).tickCount;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.left_eye.yRot = netHeadYaw / 57.295776f;
        this.left_eye.xRot = headPitch / 57.295776f;
        this.right_eye.yRot = netHeadYaw / 57.295776f;
        this.right_eye.xRot = headPitch / 57.295776f;
        this.jumpRotation = Mth.sin((float)(((FrogEntity)((Object)entityIn)).setJumpCompletion(f) * (float)Math.PI));
        this.left_top_leg.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180) + 0.27314404f;
        this.right_top_leg.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180) + 0.27314404f;
        this.left_bottom_leg.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180) + 1.0471976f;
        this.right_bottom_leg.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180) + 1.0471976f;
        this.left_foot.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.right_foot.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.left_arm.xRot = this.jumpRotation * -50.0f * ((float)Math.PI / 180) - 0.19198622f;
        this.right_arm.xRot = this.jumpRotation * -50.0f * ((float)Math.PI / 180) - 0.19198622f;
    }

    public ModelPart root() {
        return this.root;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTickTime);
        this.jumpRotation = Mth.sin((float)(((FrogEntity)((Object)entity)).setJumpCompletion(partialTickTime) * (float)Math.PI));
    }
}

