/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.model.entity;

import com.mraof.minestuck.entity.carapacian.RookEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class RookModel<T extends RookEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart leftArm;
    private final ModelPart rightArm;

    public RookModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
        this.leftArm = root.getChild("left_arm");
        this.rightArm = root.getChild("right_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        float offsetY = 24.0f;
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -6.0f, -2.0f, 18.0f, 16.0f, 12.0f), PartPose.offset((float)0.0f, (float)(-45.0f + offsetY), (float)-22.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 30).addBox(-20.0f, 0.0f, -16.0f, 40.0f, 40.0f, 26.0f).addBox("tower", 2.0f, -12.0f, -6.0f, 16, 12, 16, 60, 0).addBox("lump", -18.0f, 4.0f, -21.0f, 8, 16, 8, 124, 0), PartPose.offset((float)0.0f, (float)(-52.0f + offsetY), (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(60, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)18.0f, (float)(-12.0f + offsetY), (float)-6.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(60, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-18.0f, (float)(-12.0f + offsetY), (float)-6.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(156, 0).addBox(0.0f, 0.0f, -8.0f, 16.0f, 48.0f, 16.0f), PartPose.offsetAndRotation((float)13.0f, (float)(-50.0f + offsetY), (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.26f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(156, 0).addBox(-16.0f, 0.0f, -8.0f, 16.0f, 48.0f, 16.0f), PartPose.offsetAndRotation((float)-13.0f, (float)(-50.0f + offsetY), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.26f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)256, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 114.59155f;
        this.head.xRot = headPitch / 114.59155f;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.7f * limbSwingAmount;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount * 0.5f;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount * 0.5f;
    }
}

