/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class PlasmaParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    PlasmaParticle(ClientLevel clientLevel, double x, double y, double z, SpriteSet spriteSet) {
        super(clientLevel, x, y, z);
        this.spriteSet = spriteSet;
        this.setSpriteFromAge(this.spriteSet);
        this.lifetime = 6;
        this.scale(8.0f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.spriteSet);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            PlasmaParticle plasmaParticle = new PlasmaParticle(pLevel, pX, pY, pZ, this.spriteSet);
            plasmaParticle.pickSprite(this.spriteSet);
            return plasmaParticle;
        }
    }
}

