/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mraof.minestuck.client.ClientDimensionData;
import com.mraof.minestuck.client.renderer.SessionRenderHelper;
import com.mraof.minestuck.world.lands.LandProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public final class LandSkyRenderer {
    public static void render(int ticks, float partialTicks, Matrix4f modelViewMatrix, ClientLevel level, Minecraft mc) {
        PoseStack poseStack = new PoseStack();
        poseStack.mulPose(modelViewMatrix);
        float heightModifier = (float)Mth.clamp((double)((mc.player.position().y() - 144.0) / 112.0), (double)0.0, (double)1.0);
        float heightModifierDiminish = 1.0f - heightModifier / 1.5f;
        float skyClearness = 1.0f - level.getRainLevel(partialTicks);
        float starBrightness = level.getStarBrightness(partialTicks) * skyClearness;
        starBrightness += (float)((0.5 - (double)starBrightness) * (double)heightModifier);
        float skaiaBrightness = 0.5f + 0.5f * skyClearness * heightModifier;
        Vec3 skyColor = LandSkyRenderer.getSkyColor(mc, level, partialTicks);
        float r = (float)skyColor.x * heightModifierDiminish;
        float g = (float)skyColor.y * heightModifierDiminish;
        float b = (float)skyColor.z * heightModifierDiminish;
        FogRenderer.levelFogColor();
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionShader);
        Matrix4f matrix = LandSkyRenderer.skyBuffer(poseStack, tesselator);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (starBrightness > 0.0f) {
            RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
            SessionRenderHelper.drawRotatingVeil(poseStack, level);
            poseStack.pushPose();
            poseStack.translate(0.0f, -1.0f, 0.0f);
            RenderSystem.setShaderColor((float)(starBrightness * 2.0f), (float)(starBrightness * 2.0f), (float)(starBrightness * 2.0f), (float)(starBrightness * 2.0f));
            SessionRenderHelper.drawRotatingDerse(poseStack, level, 1.0f);
            SessionRenderHelper.drawLands(mc, poseStack, (ResourceKey<Level>)level.dimension());
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, -1.0f, 0.0f);
        if (starBrightness > 0.0f) {
            SessionRenderHelper.drawProspit(poseStack, level, 4.25f, true);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)skaiaBrightness);
        SessionRenderHelper.drawSkaia(matrix, 17.0f);
        poseStack.popPose();
        RenderSystem.disableBlend();
        LandSkyRenderer.underneathBuffer(partialTicks, level, mc, poseStack, tesselator);
        RenderSystem.depthMask((boolean)true);
    }

    private static Matrix4f skyBuffer(PoseStack poseStack, Tesselator tesselator) {
        Matrix4f matrix = poseStack.last().pose();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                buffer.addVertex(matrix, (float)k, 16.0f, (float)l);
                buffer.addVertex(matrix, (float)(k + 64), 16.0f, (float)l);
                buffer.addVertex(matrix, (float)(k + 64), 16.0f, (float)(l + 64));
                buffer.addVertex(matrix, (float)k, 16.0f, (float)(l + 64));
            }
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        return matrix;
    }

    private static void underneathBuffer(float partialTicks, ClientLevel level, Minecraft mc, PoseStack poseStack, Tesselator tesselator) {
        Matrix4f matrix = poseStack.last().pose();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d3 = mc.player.getEyePosition((float)partialTicks).y - level.getLevelData().getHorizonHeight((LevelHeightAccessor)level);
        poseStack.pushPose();
        poseStack.translate(0.0, -(d3 - 16.0), 0.0);
        RenderSystem.setShader(GameRenderer::getPositionShader);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                buffer.addVertex(matrix, (float)(k + 64), -16.0f, (float)l);
                buffer.addVertex(matrix, (float)k, -16.0f, (float)l);
                buffer.addVertex(matrix, (float)k, -16.0f, (float)(l + 64));
                buffer.addVertex(matrix, (float)(k + 64), -16.0f, (float)(l + 64));
            }
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        poseStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static Vec3 getSkyColor(Minecraft mc, ClientLevel level, float partialTicks) {
        LandProperties properties = ClientDimensionData.getProperties(level);
        if (properties != null) {
            return properties.getSkyColor();
        }
        return level.getSkyColor(mc.gameRenderer.getMainCamera().getPosition(), partialTicks);
    }
}

