/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.TextureAtlasHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class LandSkySpriteUploader
extends TextureAtlasHolder {
    public static final int VARIANT_COUNT = 3;
    private static final ResourceLocation SKAIA = Minestuck.id("skaia");
    private static final ResourceLocation PROSPIT = Minestuck.id("prospit");
    private static final ResourceLocation DERSE = Minestuck.id("derse");
    private static final ResourceLocation METEOR = Minestuck.id("meteor");
    private static LandSkySpriteUploader INSTANCE;

    public static LandSkySpriteUploader getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void initUploader(RegisterClientReloadListenersEvent event) {
        INSTANCE = new LandSkySpriteUploader(Minecraft.getInstance().getTextureManager());
        event.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    public LandSkySpriteUploader(TextureManager textureManagerIn) {
        super(textureManagerIn, ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/atlas/land_sky.png"), ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"land_sky"));
    }

    public TextureAtlasSprite getSkaiaSprite() {
        return this.getSprite(SKAIA);
    }

    public TextureAtlasSprite getProspitSprite() {
        return this.getSprite(PROSPIT);
    }

    public TextureAtlasSprite getDerseSprite() {
        return this.getSprite(DERSE);
    }

    public TextureAtlasSprite getMeteorSprite() {
        return this.getSprite(METEOR);
    }

    public TextureAtlasSprite getPlanetSprite(TerrainLandType type, int index) {
        ResourceLocation typeName = LandTypes.TERRAIN_REGISTRY.getKey((Object)type);
        Objects.requireNonNull(typeName);
        return this.getSprite(ResourceLocation.fromNamespaceAndPath((String)typeName.getNamespace(), (String)("planets/planet_" + typeName.getPath() + "_" + index)));
    }

    public TextureAtlasSprite getOverlaySprite(TitleLandType type, int index) {
        ResourceLocation typeName = LandTypes.TITLE_REGISTRY.getKey((Object)type);
        Objects.requireNonNull(typeName);
        return this.getSprite(ResourceLocation.fromNamespaceAndPath((String)typeName.getNamespace(), (String)("overlays/overlay_" + typeName.getPath() + "_" + index)));
    }
}

