/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mraof.minestuck.client.util.GuiUtil;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.block.MultiblockItem;
import com.mraof.minestuck.util.MSRotationUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class MachineOutlineRenderer {
    @SubscribeEvent
    public static void renderWorld(RenderHighlightEvent.Block event) {
        Minecraft mc = Minecraft.getInstance();
        BlockHitResult rayTrace = event.getTarget();
        if (mc.player != null && mc.getCameraEntity() == mc.player) {
            if (rayTrace.getDirection() != Direction.UP) {
                return;
            }
            if (!MachineOutlineRenderer.renderCheckItem(event.getPoseStack(), event.getMultiBufferSource(), mc.player, InteractionHand.MAIN_HAND, mc.player.getMainHandItem(), rayTrace, event.getCamera())) {
                MachineOutlineRenderer.renderCheckItem(event.getPoseStack(), event.getMultiBufferSource(), mc.player, InteractionHand.OFF_HAND, mc.player.getOffhandItem(), rayTrace, event.getCamera());
            }
        }
    }

    private static boolean renderCheckItem(PoseStack poseStack, MultiBufferSource bufferIn, LocalPlayer player, InteractionHand hand, ItemStack stack, BlockHitResult rayTraceResult, Camera info) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof MultiblockItem) {
            MultiblockItem item2 = (MultiblockItem)item;
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.lines());
            BlockPos pos = rayTraceResult.getBlockPos();
            BlockPlaceContext context = new BlockPlaceContext(new UseOnContext((Player)player, hand, rayTraceResult));
            BlockState block = player.level().getBlockState(pos);
            boolean flag = block.canBeReplaced(context);
            if (!flag) {
                pos = pos.above();
            }
            Direction placedFacing = player.getDirection().getOpposite();
            Rotation rotation = MSRotationUtil.fromDirection(placedFacing);
            double hitX = rayTraceResult.getLocation().x() - (double)pos.getX();
            double hitZ = rayTraceResult.getLocation().z() - (double)pos.getZ();
            double d1 = info.getPosition().x;
            double d2 = info.getPosition().y;
            double d3 = info.getPosition().z;
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth((float)2.0f);
            RenderSystem.depthMask((boolean)false);
            pos = item2.getPlacementPos(pos, placedFacing, hitX, hitZ);
            boolean placeable = item2.canPlaceAt(context, pos, placedFacing);
            if (item2 == MSItems.ALCHEMITER.get()) {
                AABB rod = GuiUtil.rotateAround(new AABB(3.25, 1.0, 3.25, 3.75, 4.0, 3.75), 0.5, 0.5, rotation).move(pos).move(-d1, -d2, -d3).deflate(0.002);
                AABB pad = GuiUtil.rotateAround(new AABB(0.0, 0.0, 0.0, 4.0, 1.0, 4.0), 0.5, 0.5, rotation).move(pos).move(-d1, -d2, -d3).deflate(0.002);
                MachineOutlineRenderer.drawPhernaliaPlacementOutline(poseStack, ivertexbuilder, Shapes.create((AABB)rod), 0.0, 0.0, 0.0, placeable ? 0.0f : 1.0f, placeable ? 1.0f : 0.0f, 0.0f, 0.5f);
                MachineOutlineRenderer.drawPhernaliaPlacementOutline(poseStack, ivertexbuilder, Shapes.create((AABB)pad), 0.0, 0.0, 0.0, placeable ? 0.0f : 1.0f, placeable ? 1.0f : 0.0f, 0.0f, 0.5f);
            }
            AABB boundingBox = GuiUtil.fromBoundingBox(item2.getMultiblock().getBoundingBox(rotation)).move(pos).move(-d1, -d2, -d3).deflate(0.002);
            MachineOutlineRenderer.drawPhernaliaPlacementOutline(poseStack, ivertexbuilder, Shapes.create((AABB)boundingBox), 0.0, 0.0, 0.0, placeable ? 0.0f : 1.0f, placeable ? 1.0f : 0.0f, 0.0f, 0.5f);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            return true;
        }
        return false;
    }

    private static void drawPhernaliaPlacementOutline(PoseStack poseStack, VertexConsumer bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix4f = pose.pose();
        shapeIn.forAllEdges((startX, startY, startZ, endX, endY, endZ) -> {
            float dX = (float)(endX - startX);
            float dY = (float)(endY - startY);
            float dZ = (float)(endZ - startZ);
            float length = Mth.sqrt((float)(dX * dX + dY * dY + dZ * dZ));
            bufferIn.addVertex(matrix4f, (float)(startX + xIn), (float)(startY + yIn), (float)(startZ + zIn)).setColor(red, green, blue, alpha).setNormal(pose, dX /= length, dY /= length, dZ /= length);
            bufferIn.addVertex(matrix4f, (float)(endX + xIn), (float)(endY + yIn), (float)(endZ + zIn)).setColor(red, green, blue, alpha).setNormal(pose, dX, dY, dZ);
        });
    }
}

