/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.mraof.minestuck.client.ClientDimensionData;
import com.mraof.minestuck.client.renderer.LandSkySpriteUploader;
import com.mraof.minestuck.skaianet.LandChain;
import com.mraof.minestuck.skaianet.client.SkaiaClient;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public final class SessionRenderHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void drawRotatingVeil(PoseStack poseStack, ClientLevel level) {
        poseStack.pushPose();
        poseStack.mulPose(SessionRenderHelper.getRotationQuaternion(level));
        SessionRenderHelper.drawVeil(poseStack);
        poseStack.popPose();
    }

    public static void drawVeil(PoseStack poseStack) {
        TextureAtlasSprite sprite = LandSkySpriteUploader.getInstance().getMeteorSprite();
        Random random = new Random(10842L);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int count = 0; count < 1500; ++count) {
            poseStack.pushPose();
            float size = 0.15f + random.nextFloat() * 0.1f;
            float degree = (float)count / 1500.0f * 360.0f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(degree + random.nextFloat()));
            poseStack.mulPose(Axis.XP.rotationDegrees((float)random.nextGaussian()));
            poseStack.mulPose(Axis.YP.rotationDegrees((float)random.nextGaussian()));
            Matrix4f matrix = poseStack.last().pose();
            buffer.addVertex(matrix, -size, 100.0f, -size).setUv(sprite.getU0(), sprite.getV0());
            buffer.addVertex(matrix, size, 100.0f, -size).setUv(sprite.getU1(), sprite.getV0());
            buffer.addVertex(matrix, size, 100.0f, size).setUv(sprite.getU1(), sprite.getV1());
            buffer.addVertex(matrix, -size, 100.0f, size).setUv(sprite.getU0(), sprite.getV1());
            poseStack.popPose();
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void drawRotatingSkaia(PoseStack poseStack, ClientLevel level, float skaiaSize) {
        poseStack.pushPose();
        poseStack.mulPose(SessionRenderHelper.getRotationQuaternion(level));
        SessionRenderHelper.drawSkaia(poseStack.last().pose(), skaiaSize);
        poseStack.popPose();
    }

    public static void drawSkaia(Matrix4f matrix, float size) {
        TextureAtlasSprite sprite = LandSkySpriteUploader.getInstance().getSkaiaSprite();
        SessionRenderHelper.drawSprite(matrix, size, sprite);
    }

    public static void drawRotatingProspit(PoseStack poseStack, ClientLevel level, float size, boolean spinning) {
        poseStack.pushPose();
        poseStack.mulPose(SessionRenderHelper.getRotationQuaternion(level));
        SessionRenderHelper.drawProspit(poseStack, level, size, spinning);
        poseStack.popPose();
    }

    public static void drawProspit(PoseStack poseStack, ClientLevel level, float size, boolean spinning) {
        TextureAtlasSprite sprite = LandSkySpriteUploader.getInstance().getProspitSprite();
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        if (spinning) {
            float rotateSpeed = (float)level.getGameTime() % 100000.0f * 1.0E-6f;
            matrix.rotateY(rotateSpeed * 360.0f);
            poseStack.mulPose(Axis.XP.rotation(0.25f));
        } else {
            poseStack.mulPose(Axis.XP.rotation(0.05f));
        }
        SessionRenderHelper.drawSprite(matrix, size, sprite);
        poseStack.popPose();
    }

    public static void drawRotatingDerse(PoseStack poseStack, ClientLevel level, float size) {
        poseStack.pushPose();
        poseStack.mulPose(SessionRenderHelper.getRotationQuaternion(level));
        SessionRenderHelper.drawDerse(poseStack, level, size, false);
        poseStack.popPose();
    }

    public static void drawDerse(PoseStack poseStack, ClientLevel level, float size, boolean flipSide) {
        TextureAtlasSprite sprite = LandSkySpriteUploader.getInstance().getDerseSprite();
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        if (flipSide) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
        poseStack.mulPose(Axis.XP.rotation(0.05f));
        SessionRenderHelper.drawSprite(matrix, size, sprite);
        poseStack.popPose();
    }

    public static void drawRotatingLands(Minecraft mc, PoseStack poseStack, ClientLevel level) {
        poseStack.pushPose();
        poseStack.mulPose(SessionRenderHelper.getRotationQuaternion(level));
        SessionRenderHelper.drawLands(mc, poseStack, (ResourceKey<Level>)level.dimension());
        poseStack.popPose();
    }

    public static void drawLands(Minecraft mc, PoseStack poseStack, ResourceKey<Level> dim) {
        LandChain landChain = SkaiaClient.getLandChain(dim);
        if (landChain == null) {
            return;
        }
        landChain.relativeAngledLands(dim).forEach(angledLand -> {
            if (angledLand.isZeroAngle() || angledLand.isOppositeAngle()) {
                return;
            }
            SessionRenderHelper.drawLand(poseStack, angledLand);
        });
    }

    public static void drawLand(PoseStack poseStack, LandChain.AngledLand angledLand) {
        Random random = new Random(angledLand.landId().hashCode());
        LandTypePair landTypes = ClientDimensionData.getLandTypes(angledLand.landId());
        if (landTypes == null) {
            LOGGER.warn("Missing land types for dimension {}!", angledLand.landId());
            return;
        }
        int index = random.nextInt(3);
        float v = angledLand.skaiaToLandAngle();
        float scale = 1.0f / Mth.cos((float)v);
        poseStack.pushPose();
        poseStack.mulPose(Axis.ZP.rotation(v));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)(90 * random.nextInt(4))));
        Matrix4f matrix = poseStack.last().pose();
        float planetSize = 4.0f * scale;
        SessionRenderHelper.drawSprite(matrix, planetSize, LandSkySpriteUploader.getInstance().getPlanetSprite(landTypes.getTerrain(), index));
        SessionRenderHelper.drawSprite(matrix, planetSize, LandSkySpriteUploader.getInstance().getOverlaySprite(landTypes.getTitle(), index));
        poseStack.popPose();
    }

    public static void drawSprite(Matrix4f matrix, float size, TextureAtlasSprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, -size, 100.0f, -size).setUv(sprite.getU0(), sprite.getV0());
        buffer.addVertex(matrix, size, 100.0f, -size).setUv(sprite.getU1(), sprite.getV0());
        buffer.addVertex(matrix, size, 100.0f, size).setUv(sprite.getU1(), sprite.getV1());
        buffer.addVertex(matrix, -size, 100.0f, size).setUv(sprite.getU0(), sprite.getV1());
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static float calculateRotationDegree(ClientLevel level) {
        double d0 = Mth.frac((double)((double)level.getGameTime() / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public static Quaternionf getRotationQuaternion(ClientLevel level) {
        return Axis.ZP.rotationDegrees(SessionRenderHelper.calculateRotationDegree(level) * 360.0f);
    }
}

