/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mraof.minestuck.blockentity.GateBlockEntity;
import com.mraof.minestuck.client.renderer.blockentity.ReturnNodeRenderer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

@MethodsReturnNonnullByDefault
public class GateRenderer
implements BlockEntityRenderer<GateBlockEntity> {
    private static final ResourceLocation TEXTURE = ReturnNodeRenderer.INNER_NODE;

    public GateRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(GateBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int color = blockEntityIn.color;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float tick = (float)blockEntityIn.getLevel().getGameTime() + partialTicks;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose(Axis.YP.rotation(tick / 75.0f));
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix4f = pose.pose();
        float y = 0.5f;
        VertexConsumer consumer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        consumer.addVertex(matrix4f, -1.5f, y, -1.5f).setColor(r, g, b, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix4f, -1.5f, y, 1.5f).setColor(r, g, b, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix4f, 1.5f, y, 1.5f).setColor(r, g, b, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix4f, 1.5f, y, -1.5f).setColor(r, g, b, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose, 0.0f, 1.0f, 0.0f);
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 256;
    }

    public AABB getRenderBoundingBox(GateBlockEntity blockEntity) {
        Vec3 corner = Vec3.atLowerCornerOf((Vec3i)blockEntity.getBlockPos().offset(-1, 0, -1));
        return new AABB(corner, corner.add(3.0, 1.0, 3.0));
    }
}

