/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mraof.minestuck.blockentity.ReturnNodeBlockEntity;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

@MethodsReturnNonnullByDefault
public class ReturnNodeRenderer
implements BlockEntityRenderer<ReturnNodeBlockEntity> {
    public static final ResourceLocation INNER_NODE = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/block/node_spiro_inner.png");
    public static final ResourceLocation OUTER_NODE = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/block/node_spiro_outer.png");

    public ReturnNodeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ReturnNodeBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int color = blockEntityIn.color;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float tick = (float)blockEntityIn.getLevel().getGameTime() + partialTicks;
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotation(tick / 75.0f));
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix4f = pose.pose();
        float y = 0.5f;
        VertexConsumer consumer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)INNER_NODE));
        consumer.addVertex(matrix4f, -1.0f, y, -1.0f).setColor(r, g, b, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix4f, -1.0f, y, 1.0f).setColor(r, g, b, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix4f, 1.0f, y, 1.0f).setColor(r, g, b, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix4f, 1.0f, y, -1.0f).setColor(r, g, b, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose, 0.0f, 1.0f, 0.0f);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotation(-(tick / 75.0f) / 1.5f));
        PoseStack.Pose pose2 = poseStack.last();
        Matrix4f matrix4f2 = pose2.pose();
        y = (float)(0.5 + (double)Mth.sin((float)(tick / 50.0f)) * 0.1);
        consumer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)OUTER_NODE));
        consumer.addVertex(matrix4f2, -1.0f, y, -1.0f).setColor(r, g, b, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose2, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix4f2, -1.0f, y, 1.0f).setColor(r, g, b, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose2, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix4f2, 1.0f, y, 1.0f).setColor(r, g, b, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose2, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix4f2, 1.0f, y, -1.0f).setColor(r, g, b, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLightIn).setNormal(pose2, 0.0f, 1.0f, 0.0f);
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 256;
    }

    public AABB getRenderBoundingBox(ReturnNodeBlockEntity blockEntity) {
        Vec3 corner = Vec3.atLowerCornerOf((Vec3i)blockEntity.getBlockPos().offset(-1, 0, -1));
        return new AABB(corner, corner.add(2.0, 1.0, 2.0));
    }
}

