/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mraof.minestuck.block.CruxiteDowelBlock;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.blockentity.machine.TotemLatheDowelBlockEntity;
import com.mraof.minestuck.client.model.blockentity.TotemLatheModel;
import com.mraof.minestuck.item.components.MSItemComponents;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.util.RenderUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TotemLatheRenderer
extends GeoBlockRenderer<TotemLatheDowelBlockEntity> {
    public TotemLatheRenderer(BlockEntityRendererProvider.Context ignored) {
        super((GeoModel)new TotemLatheModel());
    }

    public RenderType getRenderType(TotemLatheDowelBlockEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public void renderRecursively(PoseStack poseStack, TotemLatheDowelBlockEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        if (bone.getName().equals("totem")) {
            ItemStack dowel = ((TotemLatheDowelBlockEntity)this.animatable).getStack();
            if (dowel.isEmpty()) {
                return;
            }
            BlockState cruxiteDowel = ((Block)MSBlocks.CRUXITE_DOWEL.get()).defaultBlockState();
            if (dowel.has(MSItemComponents.ENCODED_ITEM)) {
                cruxiteDowel = (BlockState)cruxiteDowel.setValue(MSProperties.DOWEL_BLOCK, (Comparable)((Object)CruxiteDowelBlock.Type.TOTEM));
            }
            poseStack.pushPose();
            RenderUtil.translateMatrixToBone((PoseStack)poseStack, (GeoBone)bone);
            RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoBone)bone);
            poseStack.translate(0.25, -0.375, 0.03125);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            ClientLevel level = Minecraft.getInstance().level;
            BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
            BlockPos pos = animatable.getBlockPos();
            ModelData modelData = ModelData.EMPTY;
            blockRenderer.renderBatched(cruxiteDowel, pos, (BlockAndTintGetter)level, poseStack, bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)cruxiteDowel, (boolean)false)), false, level.random, modelData, null);
            poseStack.popPose();
            bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation((GeoAnimatable)animatable)));
            return;
        }
        super.renderRecursively(poseStack, (BlockEntity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public AABB getRenderBoundingBox(TotemLatheDowelBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

