/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mraof.minestuck.entity.DecoyEntity;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DecoyRenderer
extends MobRenderer<DecoyEntity, PlayerModel<DecoyEntity>> {
    private final PlayerModel<DecoyEntity> DEFAULT_MODEL = (PlayerModel)this.getModel();
    private final PlayerModel<DecoyEntity> SLIM_MODEL;

    public DecoyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 0.0f);
        this.SLIM_MODEL = new PlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
    }

    public void render(DecoyEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        PlayerSkin skin = DecoyRenderer.getSkin(entityIn.getPlayerID());
        this.model = skin.model() == PlayerSkin.Model.SLIM ? this.SLIM_MODEL : this.DEFAULT_MODEL;
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(DecoyEntity entity) {
        return DecoyRenderer.getSkin(entity.getPlayerID()).texture();
    }

    private static PlayerSkin getSkin(UUID playerID) {
        ClientPacketListener packetListener = Minecraft.getInstance().getConnection();
        PlayerInfo info = packetListener != null ? packetListener.getPlayerInfo(playerID) : null;
        return info != null ? info.getSkin() : DefaultPlayerSkin.get((UUID)playerID);
    }
}

