/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer.entity;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.Color;

@MethodsReturnNonnullByDefault
public class UnderlingRenderer<T extends UnderlingEntity>
extends GeoEntityRenderer<T> {
    private final String underlingName;

    public UnderlingRenderer(EntityRendererProvider.Context context, String underlingName) {
        super(context, (GeoModel)new DefaultedEntityGeoModel(Minestuck.id("underlings/" + underlingName), true));
        this.addRenderLayer(new UnderlingDetailsLayer(this, underlingName));
        this.underlingName = underlingName;
    }

    protected float getDeathMaxRotation(T entityLivingBaseIn) {
        return 0.0f;
    }

    public Color getRenderColor(T animatable, float partialTick, int packedLight) {
        return Color.ofOpaque((int)((UnderlingEntity)animatable).getGristType().getUnderlingColor());
    }

    public ResourceLocation getTextureLocation(T entity) {
        ResourceLocation resource = ((UnderlingEntity)entity).getGristType().getTextureId().withPath(gristName -> "textures/entity/underlings/%s_%s.png".formatted(this.underlingName, gristName));
        SimpleTexture nullTexture = new SimpleTexture(resource);
        if (Minecraft.getInstance().getTextureManager().getTexture(resource, (AbstractTexture)nullTexture) == nullTexture) {
            DynamicTexture texture = this.createLayeredTexture(entity);
            Minecraft.getInstance().getTextureManager().register(resource, (AbstractTexture)texture);
        }
        return resource;
    }

    private DynamicTexture createLayeredTexture(T entity) {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        NativeImage base = this.loadImage(resourceManager, super.getTextureLocation(entity));
        NativeImage texture = this.loadImage(resourceManager, this.getGristTexture(entity));
        NativeImage computed = new NativeImage(base.getWidth(), base.getHeight(), false);
        for (int i = 0; i < base.getWidth(); ++i) {
            for (int j = 0; j < base.getHeight(); ++j) {
                if (FastColor.ARGB32.alpha((int)base.getPixelRGBA(i, j)) == 0) {
                    computed.setPixelRGBA(i, j, 0);
                    continue;
                }
                computed.setPixelRGBA(i, j, texture.getPixelRGBA(i % texture.getWidth(), j % texture.getHeight()));
            }
        }
        return new DynamicTexture(computed);
    }

    private NativeImage loadImage(ResourceManager resourceManager, ResourceLocation location) {
        NativeImage nativeImage;
        block8: {
            Resource resource = (Resource)resourceManager.getResource(location).orElseThrow(() -> new RuntimeException("Couldn't find image %s".formatted(location)));
            InputStream inputStream = resource.open();
            try {
                nativeImage = NativeImage.read((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load image %s".formatted(location), e);
                }
            }
            inputStream.close();
        }
        return nativeImage;
    }

    private ResourceLocation getGristTexture(T entity) {
        ResourceLocation textureLocation = ((UnderlingEntity)entity).getGristType().getTextureId().withPath(textureName -> "textures/entity/underlings/" + textureName + ".png");
        if (Minecraft.getInstance().getResourceManager().getResource(textureLocation).isEmpty()) {
            return this.model.getTextureResource(entity);
        }
        return textureLocation;
    }

    private static class UnderlingDetailsLayer<T extends UnderlingEntity>
    extends GeoRenderLayer<T> {
        private final ResourceLocation textureId;

        public UnderlingDetailsLayer(GeoRenderer<T> entityRendererIn, String underlingName) {
            super(entityRendererIn);
            this.textureId = Minestuck.id("textures/entity/underlings/" + underlingName + "_details.png");
        }

        public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            RenderType layerRenderType = RenderType.entityCutoutNoCullZOffset((ResourceLocation)this.textureId);
            float contrast = this.getContrastModifier(animatable);
            poseStack.pushPose();
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, animatable, layerRenderType, bufferSource.getBuffer(layerRenderType), partialTick, packedLight, packedOverlay, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)contrast, (float)contrast, (float)contrast));
            poseStack.popPose();
        }

        private float getContrastModifier(T entity) {
            int threshold = 170;
            int color = ((UnderlingEntity)entity).getGristType().getUnderlingColor();
            int avg = (FastColor.ABGR32.red((int)color) + FastColor.ABGR32.green((int)color) + FastColor.ABGR32.blue((int)color)) / 3;
            return avg > threshold ? 0.3f : 1.0f;
        }
    }
}

