/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mraof.minestuck.entity.item.VitalityGelEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class VitalityGelRenderer
extends EntityRenderer<VitalityGelEntity> {
    public VitalityGelRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    public void render(VitalityGelEntity gel, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f + gel.getSizeByValue() / 2.0f, 0.0f);
        poseStack.scale(gel.getSizeByValue(), gel.getSizeByValue(), gel.getSizeByValue());
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose matrixstack = poseStack.last();
        Matrix4f matrix4f = matrixstack.pose();
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(gel)));
        ivertexbuilder.addVertex(matrix4f, -0.5f, -0.25f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(matrixstack, 0.0f, 1.0f, 0.0f);
        ivertexbuilder.addVertex(matrix4f, 0.5f, -0.25f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(matrixstack, 0.0f, 1.0f, 0.0f);
        ivertexbuilder.addVertex(matrix4f, 0.5f, 0.75f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(matrixstack, 0.0f, 1.0f, 0.0f);
        ivertexbuilder.addVertex(matrix4f, -0.5f, 0.75f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(matrixstack, 0.0f, 1.0f, 0.0f);
        poseStack.popPose();
        super.render((Entity)gel, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(VitalityGelEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/entity/vitality_gel.png");
    }
}

