/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.renderer.entity.frog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.client.model.MSModelLayers;
import com.mraof.minestuck.client.model.entity.FrogModel;
import com.mraof.minestuck.entity.FrogEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;

public class FrogEyesLayer
extends RenderLayer<FrogEntity, FrogModel<FrogEntity>> {
    private final FrogModel<FrogEntity> frogModel;
    private float colorMin = 0.0f;

    public FrogEyesLayer(RenderLayerParent<FrogEntity, FrogModel<FrogEntity>> renderer, EntityModelSet modelSet) {
        super(renderer);
        this.frogModel = new FrogModel(modelSet.bakeLayer(MSModelLayers.FROG));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, FrogEntity frog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!frog.isInvisible()) {
            if (frog.getFrogVariant() == FrogEntity.FrogVariants.SUSAN) {
                float g;
                float r;
                FrogEyesLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.frogModel, (ResourceLocation)this.getTextureLocation(frog), (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)frog, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (int)FastColor.ARGB32.colorFromFloat((float)1.0f, (float)r, (float)g, (float)(switch (frog.tickCount % 4) {
                    default -> {
                        r = 1.0f;
                        g = 0.0f;
                        yield 0.0f;
                    }
                    case 1 -> {
                        r = 0.0f;
                        g = 1.0f;
                        yield 0.0f;
                    }
                    case 2 -> {
                        r = 0.0f;
                        g = 0.25f;
                        yield 1.0f;
                    }
                    case 3 -> {
                        r = 0.5f;
                        g = 0.0f;
                        yield 1.0f;
                    }
                })));
            } else if (frog.getFrogVariant() == FrogEntity.FrogVariants.DEFAULT) {
                FrogEyesLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.frogModel, (ResourceLocation)this.getTextureLocation(frog), (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)frog, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (int)frog.getEyeColor());
            }
        }
    }

    public ResourceLocation getTextureLocation(FrogEntity frog) {
        if (frog.getFrogVariant() == FrogEntity.FrogVariants.SUSAN) {
            return Minestuck.id("textures/entity/frog/eyes_susan.png");
        }
        return Minestuck.id("textures/entity/frog/eyes_" + frog.getEyeType().getSerializedName() + ".png");
    }
}

