/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.sounds;

import com.mraof.minestuck.block.EnumCassetteType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PlayerMusicClientHandler {
    private static final Map<Integer, EntityBoundSoundInstance> entitiesMap = new HashMap<Integer, EntityBoundSoundInstance>();

    public static void handlePacket(int entityID, EnumCassetteType cassetteType, float volume, float pitch) {
        PlayerMusicClientHandler.checkEntitiesInMap();
        ClientLevel level = Minecraft.getInstance().level;
        Entity entity = level.getEntity(entityID);
        if (entity instanceof Player) {
            SoundManager soundManager = Minecraft.getInstance().getSoundManager();
            if (entitiesMap.containsKey(entityID)) {
                soundManager.stop((SoundInstance)entitiesMap.remove(entityID));
            }
            if (cassetteType != EnumCassetteType.NONE) {
                Holder<SoundEvent> soundEvent = cassetteType.getSoundEvent((Level)level);
                if (soundEvent == null) {
                    return;
                }
                EntityBoundSoundInstance soundInstance = new EntityBoundSoundInstance((SoundEvent)soundEvent.value(), SoundSource.PLAYERS, volume, pitch, entity, 0L);
                entitiesMap.put(entityID, soundInstance);
                soundManager.play((SoundInstance)soundInstance);
            }
        }
    }

    private static void checkEntitiesInMap() {
        for (Integer key : entitiesMap.keySet()) {
            Entity entity = Minecraft.getInstance().level.getEntity(key.intValue());
            if (entity != null) continue;
            entitiesMap.remove(key);
        }
    }
}

