/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.util;

import com.mraof.minestuck.entity.consort.EnumConsort;
import com.mraof.minestuck.inventory.ConsortMerchantMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public final class ExtraTooltips {
    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    private static void addCustomTooltip(ItemTooltipEvent event) {
        AbstractContainerMenu abstractContainerMenu;
        ItemStack stack = event.getItemStack();
        if (event.getEntity() != null && (abstractContainerMenu = event.getEntity().containerMenu) instanceof ConsortMerchantMenu) {
            ConsortMerchantMenu menu = (ConsortMerchantMenu)abstractContainerMenu;
            if (event.getEntity().containerMenu.getItems().contains((Object)stack)) {
                ExtraTooltips.handleStoreTooltips(stack, event.getToolTip(), menu);
                return;
            }
        }
        ExtraTooltips.handleCustomTooltips(stack, event.getToolTip());
    }

    private static void handleCustomTooltips(ItemStack stack, List<Component> tooltips) {
        String name;
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (itemId.getNamespace().equals("minestuck") && I18n.exists((String)(name = stack.getDescriptionId() + ".tooltip"))) {
            tooltips.add(1, (Component)Component.translatable((String)name).withStyle(ChatFormatting.GRAY));
        }
    }

    private static void handleStoreTooltips(ItemStack stack, List<Component> tooltips, ConsortMerchantMenu menu) {
        String unlocalized = stack.getDescriptionId();
        EnumConsort type = menu.getConsortType();
        MutableComponent consortDescription = Component.translatable((String)type.getConsortType().getDescriptionId());
        tooltips.clear();
        String name = "store." + unlocalized;
        if (I18n.exists((String)name)) {
            tooltips.add((Component)Component.translatable((String)name, (Object[])new Object[]{consortDescription}));
        } else {
            tooltips.add(stack.getHoverName());
        }
        String tooltip = "store." + unlocalized + ".tooltip";
        if (I18n.exists((String)tooltip)) {
            tooltips.add((Component)Component.translatable((String)tooltip, (Object[])new Object[]{consortDescription}).withStyle(ChatFormatting.GRAY));
        }
    }
}

