/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.world.lands.GristLayerInfo;
import com.mraof.minestuck.world.lands.GristTypeLayer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class GristLayerDebugRender {
    private static final boolean RENDER = false;
    private static final int RADIUS = 30;

    @SubscribeEvent
    public static void onRenderTick(RenderLevelStageEvent event) {
    }

    private static void renderGristLayer(PoseStack stack, Camera camera, Player player, GristTypeLayer layer, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        for (int x = player.getBlockX() - 30; x < player.getBlockX() + 30; ++x) {
            for (int z = player.getBlockZ() - 30; z < player.getBlockZ() + 30; ++z) {
                GristType type = layer.getTypeAt(x, z);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)type.getIcon());
                stack.pushPose();
                stack.translate((double)x - camera.getPosition().x, (double)y - camera.getPosition().y, (double)z - camera.getPosition().z);
                Matrix4f pose = stack.last().pose();
                BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                buffer.addVertex(pose, 0.0f, 0.0f, 1.0f).setUv(0.0f, 1.0f);
                buffer.addVertex(pose, 1.0f, 0.0f, 1.0f).setUv(1.0f, 1.0f);
                buffer.addVertex(pose, 1.0f, 0.0f, 0.0f).setUv(1.0f, 0.0f);
                buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setUv(0.0f, 0.0f);
                BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
                stack.popPose();
            }
        }
    }

    private static /* synthetic */ void lambda$onRenderTick$0(RenderLevelStageEvent event, Minecraft minecraft, GristLayerInfo gristLayerInfo) {
        GristLayerDebugRender.renderGristLayer(event.getPoseStack(), event.getCamera(), (Player)minecraft.player, gristLayerInfo.getCommonGristLayer(), 165);
        GristLayerDebugRender.renderGristLayer(event.getPoseStack(), event.getCamera(), (Player)minecraft.player, gristLayerInfo.getUncommonGristLayer(), 150);
        GristLayerDebugRender.renderGristLayer(event.getPoseStack(), event.getCamera(), (Player)minecraft.player, gristLayerInfo.getAnyGristLayer(), 135);
    }
}

