/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.player.ClientPlayerData;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class GuiUtil {
    public static final String NOT_ALCHEMIZABLE = "minestuck.not_alchemizable";
    public static final String FREE = "minestuck.free";
    public static final int GRIST_BOARD_WIDTH = 158;
    public static final int GRIST_BOARD_HEIGHT = 24;

    public static void drawGristBoard(GuiGraphics guiGraphics, GristSet grist, GristboardMode mode, int boardX, int boardY, Font font) {
        GuiUtil.drawGristBoard(guiGraphics, grist, mode, boardX, boardY, font, 1.0f);
    }

    public static void drawGristBoard(GuiGraphics guiGraphics, GristSet grist, GristboardMode mode, int boardX, int boardY, Font font, float scale) {
        if (grist == null) {
            guiGraphics.drawString(font, I18n.get((String)NOT_ALCHEMIZABLE, (Object[])new Object[0]), boardX, boardY, 0xFF0000, false);
            return;
        }
        if (grist.isEmpty()) {
            guiGraphics.drawString(font, I18n.get((String)FREE, (Object[])new Object[0]), boardX, boardY, 65280, false);
            return;
        }
        ClientPlayerData.ClientCache cache = ClientPlayerData.getGristCache(ClientPlayerData.CacheSource.PLAYER);
        GristSet playerGrist = cache.set();
        if (!((Boolean)MinestuckConfig.CLIENT.alchemyIcons.get()).booleanValue()) {
            int place = 0;
            for (GristAmount amount : grist.asAmounts()) {
                GristType type = amount.type();
                long need = amount.amount();
                long have = playerGrist.getGrist(type);
                int row = place % 3;
                int col = place / 3;
                int color = GuiUtil.getGristColor(mode, cache.canAfford(amount));
                String needStr = GuiUtil.addSuffix(need);
                String haveStr = GuiUtil.addSuffix(have);
                if (mode == GristboardMode.JEI_WILDCARD) {
                    guiGraphics.drawString(font, needStr + " Any Type", (float)boardX + 79.0f * (float)col, (float)boardY + 8.0f * (float)row, color, false);
                } else {
                    guiGraphics.drawString(font, needStr + " " + String.valueOf(type.getDisplayName()) + " (" + haveStr + ")", (float)boardX + 79.0f * (float)col, (float)boardY + 8.0f * (float)row, color, false);
                }
                if (mode == GristboardMode.LARGE_ALCHEMITER || mode == GristboardMode.LARGE_ALCHEMITER_SELECT) {
                    place += 2;
                }
                ++place;
            }
        } else {
            int index = 0;
            for (GristAmount amount : grist.asAmounts()) {
                ResourceLocation icon;
                int needStrWidth;
                GristType type = amount.type();
                long need = amount.amount();
                long have = playerGrist.getGrist(type);
                int row = index / 158;
                int color = GuiUtil.getGristColor(mode, need <= have);
                String needStr = GuiUtil.addSuffix(need);
                Object haveStr = "(" + GuiUtil.addSuffix(have) + ")";
                int needOffset = 1;
                int iconSize = (int)(8.0f * scale);
                int haveOffset = 1;
                if (mode == GristboardMode.JEI_WILDCARD) {
                    haveStr = "";
                    haveOffset = 0;
                }
                if (index + (needStrWidth = font.width(needStr)) + needOffset + iconSize + haveOffset + font.width((String)haveStr) > (row + 1) * 158) {
                    index = ++row * 158;
                }
                guiGraphics.drawString(font, needStr, boardX + needOffset + index % 158, boardY + 8 * row, color, false);
                guiGraphics.drawString(font, (String)haveStr, boardX + needStrWidth + needOffset + iconSize + haveOffset + index % 158, boardY + 8 * row, color, false);
                ResourceLocation resourceLocation = icon = mode == GristboardMode.JEI_WILDCARD ? GristType.DUMMY_ICON_LOCATION : type.getIcon();
                if (icon != null) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    guiGraphics.blit(icon, boardX + needStrWidth + needOffset + index % 158, boardY + 8 * row, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                }
                if (mode == GristboardMode.LARGE_ALCHEMITER || mode == GristboardMode.LARGE_ALCHEMITER_SELECT) {
                    index = (row + 1) * 158;
                    continue;
                }
                index += needStrWidth + 10 + font.width((String)haveStr);
                index = Math.min(index + 6, (row + 1) * 158);
            }
        }
    }

    public static Component getGristboardTooltip(GristSet grist, GristboardMode mode, double mouseX, double mouseY, int boardX, int boardY, Font font) {
        return GuiUtil.getGristboardTooltip(grist, mode, mouseX, mouseY, boardX, boardY, font, 1.0f);
    }

    public static Component getGristboardTooltip(GristSet grist, GristboardMode mode, double mouseX, double mouseY, int boardX, int boardY, Font font, float scale) {
        if (grist == null || grist.isEmpty()) {
            return null;
        }
        mouseX -= (double)boardX;
        mouseY -= (double)boardY;
        GristSet playerGrist = ClientPlayerData.getGristCache(ClientPlayerData.CacheSource.PLAYER).set();
        if (!((Boolean)MinestuckConfig.CLIENT.alchemyIcons.get()).booleanValue()) {
            int place = 0;
            for (GristAmount entry : grist.asAmounts()) {
                int row = place % 3;
                int col = place / 3;
                if (mouseY >= (double)(8 * row) && mouseY < (double)(8 * row + 8)) {
                    long need = entry.amount();
                    String needStr = GuiUtil.addSuffix(need);
                    if (!needStr.equals(String.valueOf(need)) && mouseX >= (double)(79.0f * (float)col) && mouseX < (double)(79.0f * (float)col + (float)font.width(needStr))) {
                        return Component.literal((String)String.valueOf(need));
                    }
                    if (mode == GristboardMode.JEI_WILDCARD) continue;
                    int width = font.width(needStr + " " + String.valueOf(entry.type().getDisplayName()) + " (");
                    long have = playerGrist.getGrist(entry.type());
                    String haveStr = GuiUtil.addSuffix(have);
                    if (!haveStr.equals(String.valueOf(have)) && mouseX >= (double)((float)boardX + 79.0f * (float)col + (float)width) && mouseX < (double)((float)boardX + 79.0f * (float)col + (float)width + (float)font.width(haveStr))) {
                        return Component.literal((String)String.valueOf(have));
                    }
                }
                ++place;
            }
        } else {
            int index = 0;
            for (GristAmount entry : grist.asAmounts()) {
                GristType type = entry.type();
                long need = entry.amount();
                long have = playerGrist.getGrist(type);
                int row = index / 158;
                String needStr = GuiUtil.addSuffix(need);
                String haveStr = GuiUtil.addSuffix(have);
                int needStrWidth = font.width(needStr);
                int haveStrWidth = font.width("(" + haveStr + ")");
                int needOffset = 1;
                int iconSize = (int)(8.0f * scale);
                int haveOffset = 1;
                if (mode == GristboardMode.JEI_WILDCARD) {
                    haveStrWidth = 0;
                    haveOffset = 0;
                    haveStr = "";
                }
                if (index + needStrWidth + needOffset + iconSize + haveOffset + haveStrWidth > (row + 1) * 158) {
                    index = ++row * 158;
                }
                if (mouseY >= (double)(8 * row) && mouseY < (double)(8 * row + 8)) {
                    if (!needStr.equals(String.valueOf(need)) && mouseX >= (double)(index % 158) && mouseX < (double)(index % 158 + needStrWidth)) {
                        return Component.literal((String)String.valueOf(need));
                    }
                    if (mouseX >= (double)(index % 158 + needStrWidth + needOffset) && mouseX < (double)(index % 158 + needStrWidth + needOffset + iconSize)) {
                        return type.getDisplayName();
                    }
                    if (!haveStr.isEmpty() && !haveStr.equals(String.valueOf(have)) && mouseX >= (double)(index % 158 + needStrWidth + needOffset + iconSize + haveOffset + font.width("(")) && mouseX < (double)(index % 158 + needStrWidth + needOffset + iconSize + haveOffset + font.width("(" + haveStr))) {
                        return Component.literal((String)String.valueOf(have));
                    }
                }
                index += needStrWidth + 10 + haveStrWidth;
                index = Math.min(index + 6, (row + 1) * 158);
            }
        }
        return null;
    }

    private static int getGristColor(GristboardMode mode, boolean hasEnough) {
        switch (mode.ordinal()) {
            case 0: 
            case 2: {
                return hasEnough ? 65280 : 0xFF0000;
            }
            case 1: 
            case 3: 
            case 5: {
                return 255;
            }
        }
        return 0;
    }

    public static String addSuffix(long n) {
        if (n < 10000L) {
            return String.valueOf(n);
        }
        if (n < 10000000L) {
            return n / 1000L + "K";
        }
        return n / 1000000L + "M";
    }

    public static AABB fromBoundingBox(BoundingBox boundingBox) {
        return new AABB((double)boundingBox.minX(), (double)boundingBox.minY(), (double)boundingBox.minZ(), (double)(boundingBox.maxX() + 1), (double)(boundingBox.maxY() + 1), (double)(boundingBox.maxZ() + 1));
    }

    public static AABB rotateAround(AABB boundingBox, double x, double z, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return boundingBox;
            }
            case CLOCKWISE_90: {
                return new AABB(x + z - boundingBox.maxZ, boundingBox.minY, z - x + boundingBox.minX, x + z - boundingBox.minZ, boundingBox.maxY, z - x + boundingBox.maxX);
            }
            case CLOCKWISE_180: {
                return new AABB(x + x - boundingBox.maxX, boundingBox.minY, z + z - boundingBox.maxZ, x + x - boundingBox.minX, boundingBox.maxY, z + z - boundingBox.minZ);
            }
            case COUNTERCLOCKWISE_90: {
                return new AABB(x - z + boundingBox.minZ, boundingBox.minY, z + x - boundingBox.maxX, x - z + boundingBox.maxZ, boundingBox.maxY, z + x - boundingBox.minX);
            }
        }
        throw new IllegalArgumentException("Invalid rotation");
    }

    public static enum GristboardMode {
        ALCHEMITER,
        ALCHEMITER_SELECT,
        LARGE_ALCHEMITER,
        LARGE_ALCHEMITER_SELECT,
        GRIST_WIDGET,
        JEI_WILDCARD;

    }
}

