/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.util;

import com.mojang.blaze3d.platform.InputConstants;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.client.gui.playerStats.PlayerStatsScreen;
import com.mraof.minestuck.computer.editmode.ClientEditHandler;
import com.mraof.minestuck.network.CaptchaDeckPackets;
import com.mraof.minestuck.network.ToggleAspectEffectsPacket;
import com.mraof.minestuck.player.ClientPlayerData;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class MSKeyHandler {
    public static final String CATEGORY = "key.categories.minestuck";
    public static final String STATS_GUI = "key.minestuck.stats_gui";
    public static final String EXIT_EDIT_MODE = "key.minestuck.exit_edit_mode";
    public static final String CAPTCHALOGUE = "key.minestuck.captchalogue";
    public static final String ASPECT_EFFECT_TOGGLE = "key.minestuck.aspext_effect_toggle";
    public static final String SYLLADEX = "key.minestuck.sylladex";
    public static KeyMapping statKey;
    public static KeyMapping editKey;
    public static KeyMapping captchaKey;
    public static KeyMapping effectToggleKey;
    public static KeyMapping sylladexKey;

    public static void registerKeys(RegisterKeyMappingsEvent event) {
        if (statKey != null) {
            throw new IllegalStateException("Minestuck keys have already been registered!");
        }
        statKey = new KeyMapping(STATS_GUI, 71, CATEGORY);
        event.register(statKey);
        editKey = new KeyMapping(EXIT_EDIT_MODE, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 75, CATEGORY);
        event.register(editKey);
        captchaKey = new KeyMapping(CAPTCHALOGUE, 86, CATEGORY);
        event.register(captchaKey);
        effectToggleKey = new KeyMapping(ASPECT_EFFECT_TOGGLE, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 92, CATEGORY);
        event.register(effectToggleKey);
        sylladexKey = new KeyMapping(SYLLADEX, -1, CATEGORY);
        event.register(sylladexKey);
    }

    @SubscribeEvent
    public static void guiKeyInput(ScreenEvent.KeyPressed.Post event) {
        InputConstants.Key input = InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode());
        if (captchaKey.isActiveAndMatches(input) && Minecraft.getInstance().screen instanceof AbstractContainerScreen) {
            MSKeyHandler.captchalogueInGui((AbstractContainerScreen)Minecraft.getInstance().screen);
            event.setCanceled(true);
        }
    }

    private static boolean isNotRelease(InputEvent.Key event) {
        return event.getAction() != 0;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (MSKeyHandler.isNotRelease(event) && Minecraft.getInstance().screen == null) {
            InputConstants.Key input = InputConstants.getKey((int)event.getKey(), (int)event.getScanCode());
            if (statKey.isActiveAndMatches(input)) {
                PlayerStatsScreen.openGui(false);
            }
            if (editKey.isActiveAndMatches(input)) {
                ClientEditHandler.onKeyPressed();
            }
            if (captchaKey.isActiveAndMatches(input)) {
                MSKeyHandler.captchalogueInGame();
            }
            if (effectToggleKey.isActiveAndMatches(input)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ToggleAspectEffectsPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (sylladexKey.isActiveAndMatches(input) && ClientPlayerData.getModus() != null) {
                MSScreenFactories.displaySylladexScreen(ClientPlayerData.getModus());
            }
        }
    }

    private static void captchalogueInGame() {
        if (!Minecraft.getInstance().player.getMainHandItem().isEmpty()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CaptchaDeckPackets.CaptchalogueHeldItem(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void captchalogueInGui(AbstractContainerScreen<?> screen) {
        Slot slot;
        if (!(screen instanceof CreativeModeInventoryScreen) && (slot = screen.getSlotUnderMouse()) != null && slot.hasItem()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CaptchaDeckPackets.CaptchalogueInventorySlot(slot.index, screen.getMenu().containerId), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

