/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.util;

import com.mraof.minestuck.util.MSSoundEvents;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MagicEffect {
    public static void rangedParticleEffect(RangedType type, ClientLevel level, Vec3 pos, Vec3 lookVector, int length, boolean collides) {
        MagicEffect.rangedParticleEffect(type.particle.get(), type.explosiveFinish, type.extraParticles, level, pos, lookVector, length, collides);
    }

    public static void rangedParticleEffect(ParticleOptions particle, boolean explosiveFinish, boolean extraParticles, ClientLevel level, Vec3 pos, Vec3 lookVector, int length, boolean collides) {
        for (int step = 0; step <= length; ++step) {
            MagicEffect.rangedPathParticles(particle, extraParticles, level, pos.add(lookVector.scale((double)step / 2.0)), step);
            if (!collides || step != length) continue;
            MagicEffect.rangedCollisionEffect(particle, explosiveFinish, level, pos.add(lookVector.scale((double)(step - 1) / 2.0)));
        }
    }

    private static void rangedPathParticles(ParticleOptions particle, boolean extraParticles, ClientLevel level, Vec3 vecPos, int i) {
        if (i >= 5) {
            float offsetX = (level.random.nextFloat() - 0.5f) / 4.0f;
            float offsetY = (level.random.nextFloat() - 0.5f) / 4.0f;
            float offsetZ = (level.random.nextFloat() - 0.5f) / 4.0f;
            level.addParticle(particle, true, vecPos.x + (double)offsetX, vecPos.y + (double)offsetY, vecPos.z + (double)offsetZ, 0.0, 0.0, 0.0);
            if (extraParticles) {
                for (float a = 0.0f; a < 4.0f; a += 1.0f) {
                    float extraOffsetX = (level.random.nextFloat() - 0.5f) / 5.0f;
                    float extraOffsetY = (level.random.nextFloat() - 0.5f) / 5.0f;
                    float extraOffsetZ = (level.random.nextFloat() - 0.5f) / 5.0f;
                    level.addParticle(particle, true, vecPos.x + (double)extraOffsetX, vecPos.y + (double)extraOffsetY, vecPos.z + (double)extraOffsetZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static void rangedCollisionEffect(ParticleOptions particle, boolean explosiveFinish, ClientLevel level, Vec3 vecPos) {
        int particles = 25 + level.random.nextInt(10);
        if (explosiveFinish) {
            level.playLocalSound(vecPos.x, vecPos.y, vecPos.z, MSSoundEvents.ITEM_MAGIC_HIT.get(), SoundSource.BLOCKS, 1.2f, 0.6f, false);
            level.addParticle((ParticleOptions)ParticleTypes.FLASH, vecPos.x, vecPos.y, vecPos.z, 0.0, 0.0, 0.0);
            for (int a = 0; a < particles; ++a) {
                level.addParticle(particle, true, vecPos.x, vecPos.y, vecPos.z, level.random.nextGaussian() * 0.12, level.random.nextGaussian() * 0.12, level.random.nextGaussian() * 0.12);
            }
        } else {
            for (int a = 0; a < particles; ++a) {
                level.addParticle((ParticleOptions)ParticleTypes.CRIT, true, vecPos.x, vecPos.y, vecPos.z, level.random.nextGaussian(), level.random.nextGaussian(), level.random.nextGaussian());
            }
        }
    }

    public static void AOEParticleEffect(AOEType type, ClientLevel level, Vec3 minAOEBound, Vec3 maxAOEBound) {
        MagicEffect.AOEParticleEffect(type.particle.get(), type.perimeterParticles, type.extraParticles, level, minAOEBound, maxAOEBound);
    }

    public static void AOEParticleEffect(ParticleOptions particle, boolean perimeterParticles, boolean extraParticles, ClientLevel level, Vec3 minAOEBound, Vec3 maxAOEBound) {
        if (!perimeterParticles) {
            return;
        }
        double minX = minAOEBound.x;
        double minZ = minAOEBound.z;
        double maxX = maxAOEBound.x;
        double maxZ = maxAOEBound.z;
        double y = (maxAOEBound.y + minAOEBound.y) / 2.0 + 4.0;
        for (double x = minX; x < maxX; x += 0.5) {
            level.addParticle(particle, true, x, y + (double)MagicEffect.randomVariation(level), minZ, 0.0, 0.0, 0.0);
            level.addParticle(particle, true, x, y + (double)MagicEffect.randomVariation(level), maxZ, 0.0, 0.0, 0.0);
            if (!extraParticles) continue;
            MagicEffect.extraParticles(particle, level, new Vec3(x, y, minZ));
            MagicEffect.extraParticles(particle, level, new Vec3(x, y, maxZ));
        }
        for (double z = minZ; z < maxZ; z += 0.5) {
            level.addParticle(particle, true, minX, y + (double)MagicEffect.randomVariation(level), z, 0.0, 0.0, 0.0);
            level.addParticle(particle, true, maxX, y + (double)MagicEffect.randomVariation(level), z, 0.0, 0.0, 0.0);
            if (!extraParticles) continue;
            MagicEffect.extraParticles(particle, level, new Vec3(minX, y, z));
            MagicEffect.extraParticles(particle, level, new Vec3(maxX, y, z));
        }
    }

    private static void extraParticles(ParticleOptions particle, ClientLevel level, Vec3 vecPos) {
        for (float a = 0.0f; a < 4.0f; a += 1.0f) {
            level.addParticle(particle, true, vecPos.x, vecPos.y + (double)MagicEffect.randomVariation(level), vecPos.z, 0.0, 0.0, 0.0);
        }
    }

    private static float randomVariation(ClientLevel level) {
        return level.random.nextFloat() - 4.0f;
    }

    public static enum RangedType {
        GREEN(() -> new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 2.0f), false, false),
        CRIT(() -> ParticleTypes.ENCHANTED_HIT, false, false),
        ENCHANT(() -> ParticleTypes.ENCHANT, false, true),
        RED(() -> new DustParticleOptions(new Vector3f(20.0f, 0.0f, 0.0f), 2.0f), false, false),
        INK(() -> ParticleTypes.SQUID_INK, true, false),
        ZILLY(() -> new DustParticleOptions(new Vector3f(20.0f, 20.0f, 20.0f), 2.0f), true, false),
        ECHIDNA(() -> ParticleTypes.END_ROD, true, false),
        WATER(() -> ParticleTypes.DRIPPING_WATER, false, true),
        FIRE(() -> ParticleTypes.DRIPPING_LAVA, false, true);

        private final Supplier<ParticleOptions> particle;
        private final boolean explosiveFinish;
        private final boolean extraParticles;

        private RangedType(Supplier<ParticleOptions> particle, boolean explosiveFinish, boolean extraParticles) {
            this.particle = particle;
            this.explosiveFinish = explosiveFinish;
            this.extraParticles = extraParticles;
        }

        public int toInt() {
            return this.ordinal();
        }

        public static RangedType fromInt(int i) {
            if (i >= 0 && i < RangedType.values().length) {
                return RangedType.values()[i];
            }
            return ENCHANT;
        }
    }

    public static enum AOEType {
        ENCHANT(() -> ParticleTypes.ENCHANT, true, false),
        WATER(() -> ParticleTypes.SPLASH, true, true),
        FIRE(() -> ParticleTypes.FLAME, true, true);

        private final Supplier<ParticleOptions> particle;
        private final boolean perimeterParticles;
        private final boolean extraParticles;

        private AOEType(Supplier<ParticleOptions> particle, boolean perimeterParticles, boolean extraParticles) {
            this.particle = particle;
            this.perimeterParticles = perimeterParticles;
            this.extraParticles = extraParticles;
        }

        public int toInt() {
            return this.ordinal();
        }

        public static AOEType fromInt(int i) {
            if (i >= 0 && i < AOEType.values().length) {
                return AOEType.values()[i];
            }
            return ENCHANT;
        }
    }
}

