/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mraof.minestuck.entry.EntryProcess;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class EntryCommand {
    public static final String OTHER_PLAYER_ENTERING = "minestuck.entry.other_player_entering";
    public static final String ENTERING = "minestuck.entry.entering";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"enter").requires(c -> c.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> EntryCommand.enter((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos"))))).executes(ctx -> EntryCommand.enter((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> EntryCommand.enter((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).getPlayerOrException(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos"))))).executes(ctx -> EntryCommand.enter((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).getPlayerOrException())));
    }

    private static int enter(CommandSourceStack src, ServerPlayer player) throws CommandSyntaxException {
        if (src.getEntity() == null || !player.equals((Object)src.getPlayerOrException())) {
            src.sendSuccess(() -> Component.translatable((String)OTHER_PLAYER_ENTERING, (Object[])new Object[]{player.getDisplayName().getString()}), false);
        } else {
            src.sendSuccess(() -> Component.translatable((String)ENTERING), false);
        }
        EntryProcess.enter(player);
        return 1;
    }

    private static int enter(CommandSourceStack src, ServerPlayer player, BlockPos pos) throws CommandSyntaxException {
        if (src.getEntity() == null || !player.equals((Object)src.getPlayerOrException())) {
            src.sendSuccess(() -> Component.translatable((String)OTHER_PLAYER_ENTERING, (Object[])new Object[]{player.getDisplayName().getString()}), false);
        } else {
            src.sendSuccess(() -> Component.translatable((String)ENTERING), false);
        }
        EntryProcess.enter(player, pos);
        return 1;
    }
}

