/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.NonNegativeGristSet;
import com.mraof.minestuck.command.argument.GristSetArgument;
import com.mraof.minestuck.player.GristCache;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class GristCommand {
    public static final String GET = "commands.minestuck.grist.get";
    public static final String ADD = "commands.minestuck.grist.add";
    public static final String SUCCESS = "commands.minestuck.grist.add.success";
    public static final String PARTIAL_SUCCESS = "commands.minestuck.grist.add.partial";
    public static final String NO_CAPACITY = "commands.minestuck.grist.add.no_capacity";
    public static final String FAILURE = "commands.minestuck.grist.add.failure";
    public static final String SET = "commands.minestuck.grist.set";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"grist").requires(source -> source.hasPermission(2))).then(GristCommand.createGet())).then(GristCommand.createAdd())).then(GristCommand.createSet()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> createGet() {
        return Commands.literal((String)"get").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(context -> GristCommand.get((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> createAdd() {
        return Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"grist", (ArgumentType)GristSetArgument.gristSet()).executes(context -> GristCommand.add((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), GristSetArgument.getGristArgument((CommandContext<CommandSourceStack>)context, "grist")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> createSet() {
        return Commands.literal((String)"set").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"grist", (ArgumentType)GristSetArgument.nonNegativeSet()).executes(context -> GristCommand.set((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), GristSetArgument.getNonNegativeGristArgument((CommandContext<CommandSourceStack>)context, "grist")))));
    }

    private static int get(CommandSourceStack source, Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            Component gristComponent = GristCache.get(player).getGristSet().asTextComponent();
            source.sendSuccess(() -> Component.translatable((String)GET, (Object[])new Object[]{player.getDisplayName(), gristComponent}), false);
        }
        return players.size();
    }

    private static int add(CommandSourceStack source, Collection<ServerPlayer> players, GristSet grist) {
        int i = 0;
        for (ServerPlayer player : players) {
            try {
                MutableGristSet remainingGrist = GristCache.get(player).addWithinCapacity(grist, GristHelper.EnumSource.CONSOLE);
                if (remainingGrist.equalContent(grist)) {
                    source.sendFailure((Component)Component.translatable((String)NO_CAPACITY, (Object[])new Object[]{player.getDisplayName()}));
                    continue;
                }
                ++i;
                if (remainingGrist.isEmpty()) {
                    source.sendSuccess(() -> Component.translatable((String)SUCCESS, (Object[])new Object[]{player.getDisplayName()}), true);
                    continue;
                }
                source.sendSuccess(() -> Component.translatable((String)PARTIAL_SUCCESS, (Object[])new Object[]{player.getDisplayName(), remainingGrist.asTextComponent()}), true);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                source.sendFailure((Component)Component.translatable((String)FAILURE, (Object[])new Object[]{player.getDisplayName()}));
            }
        }
        if (players.size() > 1) {
            int successCount = i;
            source.sendSuccess(() -> Component.translatable((String)ADD, (Object[])new Object[]{successCount}), true);
        }
        return i;
    }

    private static int set(CommandSourceStack source, Collection<ServerPlayer> players, NonNegativeGristSet grist) {
        for (ServerPlayer player : players) {
            GristCache.get(player).set(grist);
        }
        source.sendSuccess(() -> Component.translatable((String)SET, (Object[])new Object[]{players.size(), grist.asTextComponent()}), true);
        return players.size();
    }
}

