/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mraof.minestuck.world.lands.GristLayerInfo;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class GristLayerCommand {
    public static final String FAIL = "commands.minestuck.check_land.fail";
    private static final SimpleCommandExceptionType FAIL_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.minestuck.check_land.fail"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gristlayers").requires(source -> source.hasPermission(2))).executes(context -> GristLayerCommand.execute((CommandSourceStack)context.getSource())));
    }

    private static int execute(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        Optional<GristLayerInfo> optionalInfo = GristLayerInfo.get((ServerLevel)player.level());
        if (optionalInfo.isPresent()) {
            source.sendSuccess(() -> ((GristLayerInfo)optionalInfo.get()).getGristLayerInfo(player.blockPosition().getX(), player.blockPosition().getZ()), false);
            return 1;
        }
        throw FAIL_EXCEPTION.create();
    }
}

