/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mraof.minestuck.alchemy.GristGutter;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class GutterCommand {
    public static final String SHOW = "commands.minestuck.gutter.show";
    public static final SimpleCommandExceptionType NO_SESSION_EXCEPTION = new SimpleCommandExceptionType((Message)Component.literal((String)"Cannot find gutter because you are not in a session."));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"grist_gutter").requires(source -> source.hasPermission(2))).then(GutterCommand.subcommandShow()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subcommandShow() {
        return Commands.literal((String)"show").executes(context -> GutterCommand.show((CommandSourceStack)context.getSource()));
    }

    private static int show(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        Optional<GristGutter> optionalGutter = GristGutter.get(player);
        if (optionalGutter.isEmpty()) {
            throw NO_SESSION_EXCEPTION.create();
        }
        GristGutter gutter = optionalGutter.get();
        double multiplier = gutter.gutterMultiplierForSession();
        long capacity = gutter.getRemainingCapacity();
        Component gutterContentText = gutter.getCache().asTextComponent();
        source.sendSuccess(() -> Component.translatable((String)SHOW, (Object[])new Object[]{multiplier, capacity, gutterContentText}), true);
        return 1;
    }
}

