/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mraof.minestuck.item.BoondollarsItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.player.PlayerBoondollars;
import com.mraof.minestuck.player.PlayerData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PorkhollowCommand {
    public static final String SEND = "commands.minestuck.porkhollow.send";
    public static final String RECEIVE = "commands.minestuck.porkhollow.receive";
    public static final String TAKE = "commands.minestuck.porkhollow.take";
    public static final String INSUFFICIENT = "commands.minestuck.porkhollow.insufficient";
    private static final SimpleCommandExceptionType NOT_ENOUGH = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.minestuck.porkhollow.insufficient"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"porkhollow").then(PorkhollowCommand.createSend())).then(PorkhollowCommand.createTake()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> createSend() {
        return Commands.literal((String)"send").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(context -> PorkhollowCommand.send((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), LongArgumentType.getLong((CommandContext)context, (String)"amount")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> createTake() {
        return Commands.literal((String)"take").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> PorkhollowCommand.take((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))));
    }

    private static int send(CommandSourceStack source, ServerPlayer target, long amount) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        if (PlayerBoondollars.tryTakeBoondollars(PlayerData.get(player).orElseThrow(), amount)) {
            PlayerBoondollars.addBoondollars(PlayerData.get(target).orElseThrow(), amount);
            source.sendSuccess(() -> Component.translatable((String)SEND, (Object[])new Object[]{amount, target.getDisplayName()}), true);
            target.sendSystemMessage((Component)Component.translatable((String)RECEIVE, (Object[])new Object[]{amount, player.getDisplayName()}));
            return 1;
        }
        throw NOT_ENOUGH.create();
    }

    private static int take(CommandSourceStack source, int amount) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        if (PlayerBoondollars.tryTakeBoondollars(PlayerData.get(player).orElseThrow(), amount)) {
            ItemEntity entity;
            ItemStack stack = BoondollarsItem.setCount(new ItemStack((ItemLike)MSItems.BOONDOLLARS.get()), amount);
            if (!player.addItem(stack) && (entity = player.drop(stack, false)) != null) {
                entity.setNoPickUpDelay();
            }
            source.sendSuccess(() -> Component.translatable((String)TAKE, (Object[])new Object[]{amount}), true);
            return 1;
        }
        throw NOT_ENOUGH.create();
    }
}

