/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mraof.minestuck.command.MSSuggestionProviders;
import com.mraof.minestuck.command.argument.DialogueCategoryArgument;
import com.mraof.minestuck.entity.dialogue.Dialogue;
import com.mraof.minestuck.entity.dialogue.DialogueEntity;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class ReviewDialogueCommand {
    public static final String INVALID_TYPE_KEY = "commands.minestuck.review_dialouge.invalid_type";
    public static final String SUCCESS_KEY = "commands.minestuck.review_dialouge.success";
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.summon.failed"));
    private static final SimpleCommandExceptionType INVALID_TYPE = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.minestuck.review_dialouge.invalid_type"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"review_dialogue").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, (ResourceKey)Registries.ENTITY_TYPE)).suggests(MSSuggestionProviders.instance().DIALOGUE_ENTITY_TYPE).then(Commands.argument((String)"category", (ArgumentType)new DialogueCategoryArgument()).executes(context -> ReviewDialogueCommand.spawnDialogueEntities((CommandSourceStack)context.getSource(), (EntityType)ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"entity").value(), DialogueCategoryArgument.getCategory((CommandContext<CommandSourceStack>)context, "category"))))));
    }

    private static int spawnDialogueEntities(CommandSourceStack source, EntityType<?> entityType, RandomlySelectableDialogue.DialogueCategory category) throws CommandSyntaxException {
        Collection<Dialogue.SelectableDialogue> dialogueCollection = RandomlySelectableDialogue.instance(category).getAll();
        ServerLevel level = source.getLevel();
        BlockPos pos = BlockPos.containing((Position)source.getPosition());
        for (Dialogue.SelectableDialogue dialogue : dialogueCollection) {
            pos = pos.east(2);
            level.removeBlock(pos, false);
            level.setBlock(pos.below(), Blocks.BRICKS.defaultBlockState(), 3);
            DialogueEntity dialogueEntity = ReviewDialogueCommand.spawnEntity(entityType, level, pos);
            dialogueEntity.getDialogueComponent().setDialogue(dialogue.dialogueId(), true);
            ReviewDialogueCommand.placeSign(dialogue, pos, level);
        }
        source.sendSuccess(() -> Component.translatable((String)SUCCESS_KEY, (Object[])new Object[]{dialogueCollection.size()}), true);
        return dialogueCollection.size();
    }

    private static DialogueEntity spawnEntity(EntityType<?> entityType, ServerLevel level, BlockPos pos) throws CommandSyntaxException {
        Entity entity = entityType.spawn(level, pos, MobSpawnType.COMMAND);
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        entity.setNoGravity(true);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setNoAi(true);
        }
        if (entity instanceof DialogueEntity) {
            DialogueEntity dialogueEntity = (DialogueEntity)entity;
            return dialogueEntity;
        }
        throw INVALID_TYPE.create();
    }

    private static void placeSign(Dialogue.SelectableDialogue dialogue, BlockPos pos, ServerLevel level) {
        BlockPos signPos = pos.north().below();
        level.setBlock(signPos, (BlockState)Blocks.OAK_WALL_SIGN.defaultBlockState().setValue((Property)WallSignBlock.FACING, (Comparable)Direction.NORTH), 3);
        BlockEntity blockEntity = level.getBlockEntity(signPos);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            SignText signText = new SignText().setHasGlowingText(true).setColor(DyeColor.WHITE).setMessage(0, (Component)Component.literal((String)dialogue.dialogueId().getNamespace()));
            String[] lines = dialogue.dialogueId().getPath().split("/", 3);
            for (int i = 0; i < lines.length; ++i) {
                signText = signText.setMessage(i + 1, (Component)Component.literal((String)lines[i]));
            }
            sign.setText(signText, true);
        }
    }
}

