/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.player.Echeladder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class RungCommand {
    public static final String GET_SUCCESS = "commands.minestuck.get_rung";
    public static final String SET_SUCCESS = "commands.minestuck.set_rung";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rung").requires(s -> s.hasPermission(2))).then(RungCommand.subCommandGet())).then(RungCommand.subCommandSet()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandGet() {
        return Commands.literal((String)"get").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> RungCommand.getRung((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"))));
    }

    private static int getRung(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        int rung = Echeladder.get(player).getRung();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)GET_SUCCESS, (Object[])new Object[]{player.getScoreboardName(), rung}), false);
        return rung;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandSet() {
        return Commands.literal((String)"set").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"rung", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> RungCommand.setRung((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rung"), 0.0))).then(Commands.argument((String)"progress", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(context -> RungCommand.setRung((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rung"), DoubleArgumentType.getDouble((CommandContext)context, (String)"progress"))))));
    }

    private static int setRung(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, int rung, double progress) {
        for (ServerPlayer player : players) {
            Echeladder.get(player).setByCommand(rung, progress);
            MSCriteriaTriggers.ECHELADDER.get().trigger(player, rung);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)SET_SUCCESS, (Object[])new Object[]{players.size(), rung, progress}), true);
        return players.size();
    }
}

