/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.SburbConnections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SburbConnectionCommand {
    public static final String SUCCESS = "commands.minestuck.sburbconnection.success";
    public static final String ALREADY_CONNECTED = "commands.minestuck.sburbconnection.already_connected";
    public static final SimpleCommandExceptionType CONNECTED_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.minestuck.sburbconnection.already_connected"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sburbconnection").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"client", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"server", (ArgumentType)EntityArgument.player()).executes(context -> SburbConnectionCommand.connect((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"client"), EntityArgument.getPlayer((CommandContext)context, (String)"server"))))));
    }

    private static int connect(CommandSourceStack source, ServerPlayer client, ServerPlayer server) throws CommandSyntaxException {
        PlayerIdentifier serverId;
        PlayerIdentifier clientId = IdentifierHandler.encode((Player)client);
        if (SburbConnectionCommand.forceConnection(clientId, serverId = IdentifierHandler.encode((Player)server), source.getServer())) {
            source.sendSuccess(() -> Component.translatable((String)SUCCESS, (Object[])new Object[]{clientId.getUsername(), serverId.getUsername()}), true);
            return 1;
        }
        throw CONNECTED_EXCEPTION.create();
    }

    public static boolean forceConnection(PlayerIdentifier client, PlayerIdentifier server, MinecraftServer mcServer) {
        SburbConnections connections = SburbConnections.get(mcServer);
        if (connections.isPrimaryPair(client, server)) {
            return false;
        }
        if (!connections.hasPrimaryConnectionForClient(client) && connections.getActiveConnection(client).filter(connection -> connection.server().equals(server)).isPresent()) {
            connections.setPrimaryConnection(client, server);
            return true;
        }
        connections.unlinkClientPlayer(client);
        connections.unlinkServerPlayer(server);
        connections.setPrimaryConnection(client, server);
        return true;
    }
}

