/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mraof.minestuck.command.argument.TerrainLandTypeArgument;
import com.mraof.minestuck.command.argument.TitleArgument;
import com.mraof.minestuck.command.argument.TitleLandTypeArgument;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.skaianet.PredefineData;
import com.mraof.minestuck.skaianet.SkaianetData;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SburbPredefineCommand {
    public static final String SET_TITLE = "commands.minestuck.sburbpredefine.set_title";
    public static final String SET_TERRAIN_LAND = "commands.minestuck.sburbpredefine.set_terrain_land";
    public static final String SET_TITLE_LAND = "commands.minestuck.sburbpredefine.set_title_land";
    public static final String DEFINE = "commands.minestuck.sburbpredefine.define";
    public static final String TOO_LATE = "commands.minestuck.sburbpredefine.too_late";
    private static final SimpleCommandExceptionType TOO_LATE_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.minestuck.sburbpredefine.too_late"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sburbpredefine").requires(source -> source.hasPermission(2))).then(SburbPredefineCommand.subCommandTitle())).then(SburbPredefineCommand.subCommandTerrainLand())).then(SburbPredefineCommand.subCommandTitleLand())).then(SburbPredefineCommand.subCommandDefine()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandTitle() {
        return Commands.literal((String)"title").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"title", (ArgumentType)TitleArgument.title()).executes(context -> SburbPredefineCommand.setTitle((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), TitleArgument.get((CommandContext<CommandSourceStack>)context, "title")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandTerrainLand() {
        return Commands.literal((String)"terrain_land").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"land", (ArgumentType)TerrainLandTypeArgument.terrainLandType()).executes(context -> SburbPredefineCommand.setTerrainLand((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), TerrainLandTypeArgument.get((CommandContext<CommandSourceStack>)context, "land")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandTitleLand() {
        return Commands.literal((String)"title_land").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"land", (ArgumentType)TitleLandTypeArgument.titleLandType()).executes(context -> SburbPredefineCommand.setTitleLand((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), TitleLandTypeArgument.get((CommandContext<CommandSourceStack>)context, "land")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandDefine() {
        return Commands.literal((String)"define").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"title", (ArgumentType)TitleArgument.title()).then(Commands.argument((String)"title_land", (ArgumentType)TitleLandTypeArgument.titleLandType()).then(Commands.argument((String)"terrain_land", (ArgumentType)TerrainLandTypeArgument.terrainLandType()).executes(context -> SburbPredefineCommand.define((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), TitleArgument.get((CommandContext<CommandSourceStack>)context, "title"), TerrainLandTypeArgument.get((CommandContext<CommandSourceStack>)context, "terrain_land"), TitleLandTypeArgument.get((CommandContext<CommandSourceStack>)context, "title_land")))))));
    }

    private static int setTitle(CommandSourceStack source, ServerPlayer player, Title title) throws CommandSyntaxException {
        SburbPredefineCommand.getPredefineData(player).predefineTitle(title);
        source.sendSuccess(() -> Component.translatable((String)SET_TITLE, (Object[])new Object[]{player.getDisplayName(), title.asTextComponent()}), true);
        return 1;
    }

    private static int setTerrainLand(CommandSourceStack source, ServerPlayer player, TerrainLandType landType) throws CommandSyntaxException {
        SburbPredefineCommand.getPredefineData(player).predefineTerrainLand(landType, source);
        source.sendSuccess(() -> Component.translatable((String)SET_TERRAIN_LAND, (Object[])new Object[]{player.getDisplayName()}), true);
        return 1;
    }

    private static int setTitleLand(CommandSourceStack source, ServerPlayer player, TitleLandType landType) throws CommandSyntaxException {
        SburbPredefineCommand.getPredefineData(player).predefineTitleLand(landType, source);
        source.sendSuccess(() -> Component.translatable((String)SET_TITLE_LAND, (Object[])new Object[]{player.getDisplayName()}), true);
        return 1;
    }

    private static int define(CommandSourceStack source, ServerPlayer player, Title title, TerrainLandType terrainLand, TitleLandType titleLand) throws CommandSyntaxException {
        CommandSourceStack silentSource = source.withSuppressedOutput();
        PredefineData predefineData = SburbPredefineCommand.getPredefineData(player);
        predefineData.predefineTitle(title);
        predefineData.predefineTitleLand(titleLand, silentSource);
        predefineData.predefineTerrainLand(terrainLand, silentSource);
        source.sendSuccess(() -> Component.translatable((String)DEFINE, (Object[])new Object[]{player.getDisplayName()}), true);
        return 1;
    }

    private static PredefineData getPredefineData(ServerPlayer player) throws CommandSyntaxException {
        PlayerIdentifier playerId = IdentifierHandler.encode((Player)player);
        return SkaianetData.get(player.server).getOrCreatePredefineData(playerId).orElseThrow(() -> ((SimpleCommandExceptionType)TOO_LATE_EXCEPTION).create());
    }
}

