/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.NonNegativeGristSet;
import com.mraof.minestuck.command.argument.GristSetArgument;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.skaianet.SessionHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SendGristCommand {
    public static final String SUCCESS = "commands.minestuck.send_grist.success";
    public static final String RECEIVE = "commands.minestuck.send_grist.receive";
    public static final String NOT_PERMITTED = "commands.minestuck.send_grist.not_permitted";
    public static final String CANT_AFFORD = "commands.minestuck.send_grist.cant_afford";
    private static final DynamicCommandExceptionType PERMISSION_EXCEPTION = new DynamicCommandExceptionType(o -> Component.translatable((String)NOT_PERMITTED, (Object[])new Object[]{o}));
    private static final DynamicCommandExceptionType CANT_AFFORD_EXCEPTION = new DynamicCommandExceptionType(o -> Component.translatable((String)CANT_AFFORD, (Object[])new Object[]{o}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sendgrist").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"grist", (ArgumentType)GristSetArgument.nonNegativeSet()).executes(context -> SendGristCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), GristSetArgument.getNonNegativeGristArgument((CommandContext<CommandSourceStack>)context, "grist"))))));
    }

    private static int execute(CommandSourceStack source, ServerPlayer target, NonNegativeGristSet grist) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        if (SendGristCommand.isPermittedFor(player, target)) {
            if (GristCache.get(player).tryTake(grist, GristHelper.EnumSource.SENDGRIST)) {
                GristCache.get(target).addWithGutter(grist, GristHelper.EnumSource.SENDGRIST);
                source.sendSuccess(() -> Component.translatable((String)SUCCESS, (Object[])new Object[]{target.getDisplayName(), grist.asTextComponent()}), true);
                target.sendSystemMessage((Component)Component.translatable((String)RECEIVE, (Object[])new Object[]{player.getDisplayName(), grist.asTextComponent()}));
                return 1;
            }
            throw CANT_AFFORD_EXCEPTION.create((Object)grist.asTextComponent());
        }
        throw PERMISSION_EXCEPTION.create((Object)target.getDisplayName());
    }

    private static boolean isPermittedFor(ServerPlayer player, ServerPlayer player2) {
        if (!SburbPlayerData.get(player).hasEntered() || !SburbPlayerData.get(player2).hasEntered()) {
            return false;
        }
        SessionHandler sessionHandler = SessionHandler.get(player.server);
        return sessionHandler.isInSameSession(IdentifierHandler.encode((Player)player), IdentifierHandler.encode((Player)player2));
    }
}

