/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mraof.minestuck.command.MSSuggestionProviders;
import com.mraof.minestuck.entity.dialogue.DialogueEntity;
import com.mraof.minestuck.entity.dialogue.DialogueNodes;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public final class SetDialogueCommand {
    public static final String INVALID_ENTITY_KEY = "commands.minestuck.set_dialouge.invalid_entity";
    public static final String INVALID_ID_KEY = "commands.minestuck.set_dialouge.invalid_id";
    public static final String SUCCESS_KEY = "commands.minestuck.set_dialouge.success";
    private static final DynamicCommandExceptionType INVALID_ENTITY = new DynamicCommandExceptionType(entity -> Component.translatable((String)INVALID_ENTITY_KEY, (Object[])new Object[]{entity}));
    private static final DynamicCommandExceptionType INVALID_ID = new DynamicCommandExceptionType(id -> Component.translatable((String)INVALID_ID_KEY, (Object[])new Object[]{id}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set_dialogue").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"dialogue", (ArgumentType)ResourceLocationArgument.id()).suggests(MSSuggestionProviders.ALL_DIALOGUE_NODES).executes(context -> SetDialogueCommand.setDialogue((CommandSourceStack)context.getSource(), EntityArgument.getEntity((CommandContext)context, (String)"entity"), ResourceLocationArgument.getId((CommandContext)context, (String)"dialogue"))))));
    }

    private static int setDialogue(CommandSourceStack source, Entity entity, ResourceLocation id) throws CommandSyntaxException {
        if (!(entity instanceof DialogueEntity)) {
            throw INVALID_ENTITY.create((Object)entity.getDisplayName());
        }
        DialogueEntity dialogueEntity = (DialogueEntity)entity;
        if (DialogueNodes.getInstance().getDialogue(id) == null) {
            throw INVALID_ID.create((Object)id.toString());
        }
        dialogueEntity.getDialogueComponent().setDialogue(id, true);
        source.sendSuccess(() -> Component.translatable((String)SUCCESS_KEY, (Object[])new Object[]{entity.getDisplayName(), id.toString()}), true);
        return 1;
    }
}

