/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mraof.minestuck.blockentity.TransportalizerBlockEntity;
import com.mraof.minestuck.util.Teleport;
import com.mraof.minestuck.world.storage.TransportalizerSavedData;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class TransportalizerCommand {
    public static final String NOT_FOUND = "commands.minestuck.tpz.not_found";
    public static final String FAILURE = "commands.minestuck.tpz.failure";
    public static final String RESULT = "commands.minestuck.tpz.result";
    public static final String FAILURE_RESULT = "commands.minestuck.tpz.failure_result";
    private static final DynamicCommandExceptionType NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(o -> Component.translatable((String)NOT_FOUND, (Object[])new Object[]{o}));
    private static final SimpleCommandExceptionType BLOCKED_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"minestuck.transportalizer.blocked_destination"));
    private static final SimpleCommandExceptionType RESULT_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.minestuck.tpz.failure_result"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpz").requires(commandSource -> commandSource.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"code", (ArgumentType)StringArgumentType.word()).executes(context -> TransportalizerCommand.teleport((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).getEntityOrException()), StringArgumentType.getString((CommandContext)context, (String)"code")))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(context -> TransportalizerCommand.teleport((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"code"))))));
    }

    private static int teleport(CommandSourceStack source, Collection<? extends Entity> entities, String code) throws CommandSyntaxException {
        code = code.toUpperCase(Locale.ROOT);
        GlobalPos destination = TransportalizerSavedData.get(source.getServer()).get(code);
        if (destination == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)code);
        }
        ServerLevel level = source.getServer().getLevel(destination.dimension());
        if (level == null || !(level.getBlockEntity(destination.pos()) instanceof TransportalizerBlockEntity)) {
            throw NOT_FOUND_EXCEPTION.create((Object)code);
        }
        if (TransportalizerBlockEntity.isBlocked((Level)level, destination.pos())) {
            throw BLOCKED_EXCEPTION.create();
        }
        int count = 0;
        for (Entity entity : entities) {
            Entity newEntity = Teleport.teleportEntity(entity, level, (double)destination.pos().getX() + 0.5, (double)destination.pos().getY() + 0.6, (double)destination.pos().getZ() + 0.5, entity.getYRot(), entity.getXRot());
            if (newEntity != null) {
                newEntity.setPortalCooldown();
                ++count;
                continue;
            }
            source.sendFailure((Component)Component.translatable((String)FAILURE, (Object[])new Object[]{entity.getDisplayName()}));
        }
        if (count == 0) {
            throw RESULT_EXCEPTION.create();
        }
        int finalCount = count;
        source.sendSuccess(() -> Component.translatable((String)RESULT, (Object[])new Object[]{finalCount}), true);
        return count;
    }
}

