/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mraof.minestuck.world.gen.structure.wfc.ProspitWFCDemoStructure;
import com.mraof.minestuck.world.gen.structure.wfc.WFC;
import com.mraof.minestuck.world.gen.structure.wfc.WFCData;
import com.mraof.minestuck.world.gen.structure.wfc.WFCUtil;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public final class WFCPerformanceTestCommand {
    private static int timesToRun = 0;
    private static final StructurePieceAccessor DUMMY_PIECE_ACCESSOR = new StructurePieceAccessor(){

        public void addPiece(StructurePiece piece) {
        }

        @Nullable
        public StructurePiece findCollisionPiece(BoundingBox box) {
            return null;
        }
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wfc_performance_test").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"times", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            WFCPerformanceTestCommand.run(IntegerArgumentType.getInteger((CommandContext)context, (String)"times"), ((CommandSourceStack)context.getSource()).getLevel().getStructureManager());
            return 1;
        }))).executes(context -> {
            WFCPerformanceTestCommand.run((RegistryAccess)((CommandSourceStack)context.getSource()).getServer().registryAccess(), ((CommandSourceStack)context.getSource()).getLevel().getStructureManager());
            return 1;
        }));
    }

    private static void run(int times, StructureTemplateManager templateManager) {
        timesToRun = times;
    }

    @SubscribeEvent
    private static void onTick(ServerTickEvent.Post event) {
        if (timesToRun > 0 && event.hasTime() && event.getServer().getTickCount() % 40 == 0) {
            --timesToRun;
            WFCPerformanceTestCommand.run((RegistryAccess)event.getServer().registryAccess(), event.getServer().getStructureManager());
        }
    }

    private static void run(RegistryAccess registryAccess, StructureTemplateManager templateManager) {
        HolderLookup.RegistryLookup paletteLookup = registryAccess.lookupOrThrow(WFCData.PaletteData.REGISTRY_KEY);
        WFCUtil.PerformanceMeasurer performanceMeasurer = new WFCUtil.PerformanceMeasurer();
        PositionalRandomFactory randomFactory = RandomSource.create((long)1L).forkPositional();
        WFCUtil.PositionTransform middleTransform = new WFCUtil.PositionTransform(BlockPos.ZERO, ProspitWFCDemoStructure.CELL_SIZE);
        WFCData.EntryPalette centerPalette = ((WFCData.PaletteData)paletteLookup.getOrThrow(ProspitWFCDemoStructure.Palettes.NORMAL).value()).build(ProspitWFCDemoStructure.CELL_SIZE, templateManager);
        WFCData.EntryPalette borderPalette = ((WFCData.PaletteData)paletteLookup.getOrThrow(ProspitWFCDemoStructure.Palettes.BORDER).value()).build(ProspitWFCDemoStructure.CELL_SIZE, templateManager);
        WFC.InfiniteModularGeneration.generateModule(middleTransform, ProspitWFCDemoStructure.WFC_DIMENSIONS, centerPalette, borderPalette, randomFactory, DUMMY_PIECE_ACCESSOR, performanceMeasurer);
        System.out.printf("Measured performance: %s%n", performanceMeasurer);
    }
}

