/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public final class DialogueCategoryArgument
implements ArgumentType<RandomlySelectableDialogue.DialogueCategory> {
    public static final String INVALID = "argument.dialogue_category.invalid";
    public static final DynamicCommandExceptionType INVALID_TYPE = new DynamicCommandExceptionType(o -> Component.translatable((String)INVALID, (Object[])new Object[]{o}));
    public static final Collection<String> CATEGORY_STRINGS = Stream.of(RandomlySelectableDialogue.DialogueCategory.values()).map(RandomlySelectableDialogue.DialogueCategory::folderName).toList();

    public RandomlySelectableDialogue.DialogueCategory parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        String name = reader.readUnquotedString();
        Optional<RandomlySelectableDialogue.DialogueCategory> categoryOptional = Stream.of(RandomlySelectableDialogue.DialogueCategory.values()).filter(category -> category.name().equalsIgnoreCase(name)).findAny();
        if (categoryOptional.isEmpty()) {
            reader.setCursor(start);
            throw INVALID_TYPE.createWithContext((ImmutableStringReader)reader, (Object)name);
        }
        return categoryOptional.get();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(CATEGORY_STRINGS, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return CATEGORY_STRINGS;
    }

    public static RandomlySelectableDialogue.DialogueCategory getCategory(CommandContext<CommandSourceStack> context, String id) {
        return (RandomlySelectableDialogue.DialogueCategory)((Object)context.getArgument(id, RandomlySelectableDialogue.DialogueCategory.class));
    }
}

