/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mraof.minestuck.api.alchemy.DefaultMutableGristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.NonNegativeGristSet;
import com.mraof.minestuck.command.argument.GristTypeArgument;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class GristSetArgument
implements ArgumentType<MutableGristSet> {
    public static final String INCOMPLETE = "argument.grist_set.incomplete";
    public static final String DUPLICATE = "argument.grist_set.duplicate";
    public static final SimpleCommandExceptionType SET_INCOMPLETE = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.grist_set.incomplete"));
    public static final DynamicCommandExceptionType DUPLICATE_TYPE = new DynamicCommandExceptionType(o -> Component.translatable((String)DUPLICATE, (Object[])new Object[]{o}));
    private static final GristTypeArgument gristArgument = GristTypeArgument.gristType();
    private final IntegerArgumentType intArgument;
    private final Mode mode;

    private GristSetArgument(Mode mode) {
        this.mode = mode;
        this.intArgument = mode == Mode.NON_NEGATIVE ? IntegerArgumentType.integer((int)0) : IntegerArgumentType.integer();
    }

    public static GristSetArgument gristSet() {
        return new GristSetArgument(Mode.STANDARD);
    }

    public static GristSetArgument nonNegativeSet() {
        return new GristSetArgument(Mode.NON_NEGATIVE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public MutableGristSet parse(StringReader reader) throws CommandSyntaxException {
        int start1;
        block3: {
            MutableGristSet set = this.mode == Mode.NON_NEGATIVE ? new NonNegativeGristSet() : MutableGristSet.newDefault();
            do {
                start1 = reader.getCursor();
                int count = this.intArgument.parse(reader);
                if (!reader.canRead() || reader.peek() != ' ') break block3;
                reader.skip();
                int start2 = reader.getCursor();
                GristType type = gristArgument.parse(reader);
                if (set.hasType(type)) {
                    reader.setCursor(start2);
                    throw DUPLICATE_TYPE.createWithContext((ImmutableStringReader)reader, (Object)type.toString());
                }
                set.add(type, (long)count);
                if (!reader.canRead() || reader.peek() != ' ') return set;
                reader.skip();
            } while (reader.canRead());
            return set;
        }
        reader.setCursor(start1);
        throw SET_INCOMPLETE.createWithContext((ImmutableStringReader)reader);
    }

    public static MutableGristSet getGristArgument(CommandContext<CommandSourceStack> context, String id) {
        return (MutableGristSet)context.getArgument(id, DefaultMutableGristSet.class);
    }

    public static NonNegativeGristSet getNonNegativeGristArgument(CommandContext<CommandSourceStack> context, String id) {
        return (NonNegativeGristSet)context.getArgument(id, NonNegativeGristSet.class);
    }

    private static enum Mode {
        STANDARD,
        NON_NEGATIVE;

    }

    public static final class Info
    implements ArgumentTypeInfo<GristSetArgument, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.writeEnum((Enum)template.mode);
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            Mode mode = (Mode)buffer.readEnum(Mode.class);
            return new Template(mode);
        }

        public void serializeToJson(Template template, JsonObject json) {
            switch (template.mode.ordinal()) {
                case 1: {
                    json.addProperty("type", "non_negative");
                    break;
                }
                default: {
                    json.addProperty("type", "standard");
                }
            }
        }

        public Template unpack(GristSetArgument argument) {
            return new Template(argument.mode);
        }

        public class Template
        implements ArgumentTypeInfo.Template<GristSetArgument> {
            final Mode mode;

            public Template(Mode mode) {
                this.mode = mode;
            }

            public GristSetArgument instantiate(CommandBuildContext context) {
                return new GristSetArgument(this.mode);
            }

            public ArgumentTypeInfo<GristSetArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

