/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GristTypeArgument
implements ArgumentType<GristType> {
    private static final List<String> EXAMPLES = Arrays.asList("minestuck:build", "minestuck:marble", "minestuckarsenal:iron");
    public static final String INVALID = "argument.grist_type.invalid";
    public static final DynamicCommandExceptionType INVALID_TYPE = new DynamicCommandExceptionType(o -> Component.translatable((String)INVALID, (Object[])new Object[]{o}));

    public static GristTypeArgument gristType() {
        return new GristTypeArgument();
    }

    public GristType parse(StringReader reader) throws CommandSyntaxException {
        int start2 = reader.getCursor();
        ResourceLocation gristName = ResourceLocation.read((StringReader)reader);
        if (!GristTypes.REGISTRY.containsKey(gristName)) {
            reader.setCursor(start2);
            throw INVALID_TYPE.createWithContext((ImmutableStringReader)reader, (Object)gristName.toString());
        }
        return (GristType)GristTypes.REGISTRY.get(gristName);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggestResource((Iterable)GristTypes.REGISTRY.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static GristType getGristArgument(CommandContext<CommandSourceStack> context, String id) {
        return (GristType)context.getArgument(id, GristType.class);
    }
}

