/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public class ListArgument<T>
implements ArgumentType<List<T>> {
    private final ArgumentType<T> elementArgument;

    private ListArgument(ArgumentType<T> elementArgument) {
        this.elementArgument = Objects.requireNonNull(elementArgument);
    }

    public static <T> ListArgument<T> list(ArgumentType<T> argument) {
        return new ListArgument<T>(argument);
    }

    public List<T> parse(StringReader reader) throws CommandSyntaxException {
        ArrayList<Object> list = new ArrayList<Object>();
        do {
            Object t = this.elementArgument.parse(reader);
            list.add(t);
            if (!reader.canRead() || reader.peek() != ' ') break;
            reader.skip();
        } while (reader.canRead());
        return list;
    }

    public static <T> List<T> getListArgument(CommandContext<CommandSourceStack> context, String id) {
        return (List)context.getArgument(id, List.class);
    }

    public static final class Info<T>
    implements ArgumentTypeInfo<ListArgument<T>, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            Info.serializeArgument(buffer, template.elementArgument);
        }

        private static <A extends ArgumentType<?>> void serializeArgument(FriendlyByteBuf buffer, ArgumentTypeInfo.Template<A> template) {
            Info.serializeArgument(buffer, template.type(), template);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeArgument(FriendlyByteBuf buffer, ArgumentTypeInfo<A, T> argumentInfo, ArgumentTypeInfo.Template<A> template) {
            buffer.writeById(arg_0 -> ((Registry)BuiltInRegistries.COMMAND_ARGUMENT_TYPE).getId(arg_0), argumentInfo);
            argumentInfo.serializeToNetwork(template, buffer);
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            try {
                ArgumentTypeInfo elementArgInfo = (ArgumentTypeInfo)buffer.readById(arg_0 -> ((Registry)BuiltInRegistries.COMMAND_ARGUMENT_TYPE).byId(arg_0));
                return new Template(elementArgInfo.deserializeFromNetwork(buffer));
            }
            catch (Exception e) {
                return null;
            }
        }

        public void serializeToJson(Template template, JsonObject json) {
            throw new UnsupportedOperationException();
        }

        public Template unpack(ListArgument<T> argument) {
            return new Template(ArgumentTypeInfos.unpack(argument.elementArgument));
        }

        public class Template
        implements ArgumentTypeInfo.Template<ListArgument<T>> {
            final ArgumentTypeInfo.Template<? extends ArgumentType<T>> elementArgument;

            public Template(ArgumentTypeInfo.Template<? extends ArgumentType<T>> elementArgument) {
                this.elementArgument = elementArgument;
            }

            public ListArgument<T> instantiate(CommandBuildContext context) {
                return new ListArgument(this.elementArgument.instantiate(context));
            }

            public ArgumentTypeInfo<ListArgument<T>, ?> type() {
                return Info.this;
            }
        }
    }
}

