/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.EnumClass;
import com.mraof.minestuck.player.Title;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class TitleArgument
implements ArgumentType<Title> {
    private static final List<String> EXAMPLES = Arrays.asList("heir light", "bard void", "lord doom");
    public static final String INCOMPLETE = "argument.title.incomplete";
    public static final String INVALID_CLASS = "argument.title.invalid_class";
    public static final String INVALID_ASPECT = "argument.title.invalid_aspect";
    private static final SimpleCommandExceptionType PAIR_INCOMPLETE = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.title.incomplete"));
    private static final DynamicCommandExceptionType INVALID_CLASS_TYPE = new DynamicCommandExceptionType(o -> Component.translatable((String)INVALID_CLASS, (Object[])new Object[]{o}));
    private static final DynamicCommandExceptionType INVALID_ASPECT_TYPE = new DynamicCommandExceptionType(o -> Component.translatable((String)INVALID_ASPECT, (Object[])new Object[]{o}));

    public static TitleArgument title() {
        return new TitleArgument();
    }

    public Title parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw PAIR_INCOMPLETE.createWithContext((ImmutableStringReader)reader);
        }
        String className = reader.readUnquotedString();
        EnumClass c = EnumClass.fromString(className);
        if (c == null) {
            throw INVALID_CLASS_TYPE.createWithContext((ImmutableStringReader)reader, (Object)className);
        }
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            String aspectName = reader.readUnquotedString();
            EnumAspect a = EnumAspect.fromString(aspectName);
            if (a == null) {
                throw INVALID_ASPECT_TYPE.createWithContext((ImmutableStringReader)reader, (Object)aspectName);
            }
            return new Title(c, a);
        }
        throw PAIR_INCOMPLETE.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        if (!remaining.contains(" ")) {
            return SharedSuggestionProvider.suggest(Stream.of(EnumClass.values()).map(EnumClass::toString), (SuggestionsBuilder)builder);
        }
        String[] parts = remaining.split(" ");
        EnumClass c = EnumClass.fromString(parts[0]);
        if (c == null) {
            return Suggestions.empty();
        }
        return SharedSuggestionProvider.suggest(Stream.of(EnumAspect.values()).map(a -> parts[0] + " " + String.valueOf(a)), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static Title get(CommandContext<CommandSourceStack> context, String id) {
        return (Title)context.getArgument(id, Title.class);
    }
}

